/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509.ext;

import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.AccessDescription;
import com.bifit.security.pkix.x509.Extension;
import com.bifit.security.pkix.x509.Name;
import com.bifit.security.pkix.x509.ext.BaseExtension;

public class ServiceLocator
extends BaseExtension {
    private Name a;
    private ASN1Sequence b = new ASN1Sequence();
    public static final ASN1ObjectIdentifier OID = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.48.1.7");
    private static final ASN1Sequence.Template c = new ASN1Sequence.Template();

    public ServiceLocator(Name name) {
        super(ServiceLocator.class);
        this.debug("issuer = " + name);
        PKIXUtils.verifyNotNull(name);
        this.a = name;
    }

    public ServiceLocator(Extension extension) throws InvalidBERException {
        super(extension, ServiceLocator.class, OID);
        extension = ASN1Sequence.getInstance((ASN1Template)c, (byte[])extension.getContent());
        this.a = (Name)extension.elementAt(0);
        this.b = (ASN1Sequence)extension.elementAt(1);
    }

    public Name getIssuer() {
        return this.a;
    }

    public void setIssuer(Name name) {
        this.debug("issuer = " + name);
        PKIXUtils.verifyNotNull(name);
        this.a = name;
    }

    public void addElement(AccessDescription accessDescription) {
        this.b.addElement((ASN1Value)accessDescription);
    }

    public AccessDescription elementAt(int n) {
        return (AccessDescription)this.b.elementAt(n);
    }

    public void insertElementAt(AccessDescription accessDescription, int n) {
        this.b.insertElementAt((ASN1Value)accessDescription, n);
    }

    public void removeElementAt(int n) {
        this.b.removeElementAt(n);
    }

    public void removeAllElements() {
        this.b.removeAllElements();
    }

    public int size() {
        return this.b.size();
    }

    @Override
    public Extension getExtension(boolean bl) {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        if (this.b != null && this.b.size() > 0) {
            aSN1Sequence.addElement((ASN1Value)this.b);
        }
        return this.buildExtension(OID, bl, aSN1Sequence.encode());
    }

    public int hashCode() {
        int n = 31 + (this.a == null ? 0 : this.a.hashCode());
        n = n * 31 + (this.b == null ? 0 : this.b.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (ServiceLocator)object;
        if (this.a == null ? ((ServiceLocator)object).a != null : !this.a.equals(((ServiceLocator)object).a)) {
            return false;
        }
        return !(this.b == null ? ((ServiceLocator)object).b != null : !this.b.equals((Object)((ServiceLocator)object).b));
    }

    public String toString() {
        return "ServiceLocator [issuer=" + this.a + ", locator=" + this.b + "]";
    }

    static {
        c.addElement(Name.TEMPLATE);
        c.addOptionalElement((ASN1Template)ASN1Sequence.getSequenceTemplate((ASN1Template)AccessDescription.TEMPLATE));
    }
}

