/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509.ext;

import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.Extension;
import com.bifit.security.pkix.x509.QCStatement;
import com.bifit.security.pkix.x509.ext.BaseExtension;

public class QCStatements
extends BaseExtension {
    private final ASN1Sequence a;
    public static final ASN1ObjectIdentifier OID = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.1.3");
    private static final ASN1Sequence.OF_Template b = new ASN1Sequence.OF_Template(QCStatement.TEMPLATE);

    public QCStatements(Extension extension) throws InvalidBERException {
        super(extension, QCStatements.class, OID);
        this.a = ASN1Sequence.getInstance((ASN1Template)b, (byte[])extension.getContent());
    }

    public QCStatements() {
        super(QCStatements.class);
        this.a = new ASN1Sequence();
    }

    public void addStatement(QCStatement qCStatement) {
        this.debug("statement = " + qCStatement);
        PKIXUtils.verifyNotNull(qCStatement);
        this.a.addElement((ASN1Value)qCStatement);
    }

    public QCStatement statementAt(int n) {
        this.debug("INDEX = " + n);
        return (QCStatement)this.a.elementAt(n);
    }

    public void insertStatementAt(QCStatement qCStatement, int n) {
        this.debug("statement = " + qCStatement + ", index = " + n);
        PKIXUtils.verifyNotNull(qCStatement);
        this.a.insertElementAt((ASN1Value)qCStatement, n);
    }

    public void removeStatementAt(int n) {
        this.debug("INDEX = " + n);
        this.a.removeElementAt(n);
    }

    public int size() {
        return this.a.size();
    }

    @Override
    public Extension getExtension(boolean bl) {
        return this.buildExtension(OID, bl, this.a.encode());
    }

    public int hashCode() {
        return 31 + (this.a == null ? 0 : this.a.hashCode());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (QCStatements)object;
        return !(this.a == null ? ((QCStatements)object).a != null : !this.a.equals((Object)((QCStatements)object).a));
    }

    public String toString() {
        return "QCStatements [statements=" + this.a + "]";
    }
}

