/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509.ext;

import com.bifit.security.asn1.ASN1Explicit;
import com.bifit.security.asn1.ASN1GeneralizedTime;
import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.log.LogParam;
import com.bifit.security.pkix.x509.Extension;
import com.bifit.security.pkix.x509.ext.BaseExtension;
import java.util.Date;

public class PrivateKeyUsagePeriod
extends BaseExtension {
    private Date a;
    private Date b;
    public static final ASN1ObjectIdentifier OID = new ASN1ObjectIdentifier("2.5.29.16");
    private static final ASN1Sequence.Template c = new ASN1Sequence.Template();

    public PrivateKeyUsagePeriod(Extension extension) throws InvalidBERException {
        super(extension, PrivateKeyUsagePeriod.class, OID);
        ASN1GeneralizedTime aSN1GeneralizedTime;
        extension = ASN1Sequence.getInstance((ASN1Template)c, (byte[])extension.getContent());
        if (extension.elementAt(0) != null) {
            aSN1GeneralizedTime = (ASN1GeneralizedTime)((ASN1Explicit)extension.elementAt(0)).getContent();
            this.a = aSN1GeneralizedTime.toDate();
        }
        if (extension.elementAt(1) != null) {
            aSN1GeneralizedTime = (ASN1GeneralizedTime)((ASN1Explicit)extension.elementAt(1)).getContent();
            this.b = aSN1GeneralizedTime.toDate();
        }
        this.debug(LogParam.form("notBefore=" + this.a + ", notAfter=" + this.b));
    }

    public PrivateKeyUsagePeriod() {
        super(PrivateKeyUsagePeriod.class);
    }

    public Date getNotBefore() {
        return new Date(this.a.getTime());
    }

    public void setNotBefore(Date date) {
        this.debug("notBefore=" + date);
        this.a = new Date(date.getTime());
    }

    public Date getNotAfter() {
        return new Date(this.b.getTime());
    }

    public void setNotAfter(Date date) {
        this.debug("notAfter=" + date);
        this.b = new Date(date.getTime());
    }

    @Override
    public Extension getExtension(boolean bl) {
        ASN1GeneralizedTime aSN1GeneralizedTime;
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        if (this.a != null) {
            aSN1GeneralizedTime = new ASN1GeneralizedTime(this.a);
            aSN1Sequence.addElement((ASN1Value)new ASN1Explicit(ASN1Tag.get((long)0L), (ASN1Value)aSN1GeneralizedTime));
        }
        if (this.b != null) {
            aSN1GeneralizedTime = new ASN1GeneralizedTime(this.b);
            aSN1Sequence.addElement((ASN1Value)new ASN1Explicit(ASN1Tag.get((long)1L), (ASN1Value)aSN1GeneralizedTime));
        }
        return this.buildExtension(OID, bl, aSN1Sequence.encode());
    }

    public int hashCode() {
        int n = 31 + (this.b == null ? 0 : this.b.hashCode());
        n = n * 31 + (this.a == null ? 0 : this.a.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (PrivateKeyUsagePeriod)object;
        if (this.b == null ? ((PrivateKeyUsagePeriod)object).b != null : !this.b.equals(((PrivateKeyUsagePeriod)object).b)) {
            return false;
        }
        return !(this.a == null ? ((PrivateKeyUsagePeriod)object).a != null : !this.a.equals(((PrivateKeyUsagePeriod)object).a));
    }

    public String toString() {
        return "PrivateKeyUsagePeriod [notBefore=" + this.a + ", notAfter=" + this.b + "]";
    }

    static {
        c.addOptionalElement((ASN1Template)new ASN1Explicit.Template(ASN1Tag.get((long)0L), ASN1GeneralizedTime.TEMPLATE));
        c.addOptionalElement((ASN1Template)new ASN1Explicit.Template(ASN1Tag.get((long)1L), ASN1GeneralizedTime.TEMPLATE));
    }
}

