/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509.ext;

import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.Extension;
import com.bifit.security.pkix.x509.ext.BaseExtension;
import java.util.Arrays;

public class Nonce
extends BaseExtension {
    private final byte[] a;
    public static final ASN1ObjectIdentifier OID = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.48.1.2");

    public Nonce(byte[] byArray) {
        super(Nonce.class);
        this.debug("VALUE = " + PKIXUtils.arrayToString(byArray));
        this.a = PKIXUtils.copy(byArray);
    }

    public Nonce(Extension extension) {
        super(extension, Nonce.class, OID);
        this.a = extension.getContent();
    }

    public byte[] getData() {
        return PKIXUtils.copy(this.a);
    }

    @Override
    public Extension getExtension(boolean bl) {
        return this.buildExtension(OID, bl, this.a);
    }

    public int hashCode() {
        return 31 + Arrays.hashCode(this.a);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (Nonce)object;
        return Arrays.equals(this.a, ((Nonce)object).a);
    }

    public String toString() {
        return "Nonce [data=" + Arrays.toString(this.a) + "]";
    }
}

