/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509;

import com.bifit.security.asn1.ASN1Integer;
import com.bifit.security.asn1.InvalidBERException;

public enum Version {
    v1(1, 0),
    v2(2, 1),
    v3(3, 2);

    private int a;
    private int b;

    private Version(int n2, int n3) {
        this.b = n2;
        this.a = n3;
    }

    public final ASN1Integer getASNValue() {
        return new ASN1Integer((long)this.a);
    }

    public final int getIntValue() {
        return this.a;
    }

    public final int getIntNumber() {
        return this.b;
    }

    public static Version fromASNInt(ASN1Integer aSN1Integer) throws InvalidBERException {
        int n = aSN1Integer.intValue();
        switch (n) {
            case 0: {
                return v1;
            }
            case 1: {
                return v2;
            }
            case 2: {
                return v3;
            }
        }
        throw new InvalidBERException("Unrecognized version number");
    }

    public static Version fromVersionNumber(int n) {
        for (Version version : Version.values()) {
            if (version.b != n) continue;
            return version;
        }
        throw new IllegalArgumentException("Unsupported version number");
    }
}

