/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509;

import com.bifit.security.asn1.ASN1BitString;
import com.bifit.security.asn1.ASN1Explicit;
import com.bifit.security.asn1.ASN1Integer;
import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.DecodeExtensionException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.AlgorithmIdentifier;
import com.bifit.security.pkix.x509.Extension;
import com.bifit.security.pkix.x509.Extensions;
import com.bifit.security.pkix.x509.Name;
import com.bifit.security.pkix.x509.SubjectPublicKeyInfo;
import com.bifit.security.pkix.x509.Validity;
import com.bifit.security.pkix.x509.Version;
import com.bifit.security.pkix.x509.ext.BaseExtension;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TBSCertificate
extends AbstractASN1Sequence {
    private Version a;
    private ASN1Integer b;
    private AlgorithmIdentifier c;
    private Name d;
    private Validity e;
    private Name f;
    private SubjectPublicKeyInfo g;
    private ASN1BitString h;
    private ASN1BitString i;
    private Extensions j;
    public static final ASN1Template TEMPLATE = new a();

    public static TBSCertificate getInstance(byte[] byArray) throws PKIXException {
        try {
            return (TBSCertificate)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    public TBSCertificate(Version version, ASN1Integer aSN1Integer, AlgorithmIdentifier algorithmIdentifier, Name name, Validity validity, Name name2, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        super(TBSCertificate.class);
        this.debug("ver = " + (Object)((Object)version) + ", serial = " + PKIXUtils.arrayToString(aSN1Integer.toByteArray()) + ", signAlg = " + algorithmIdentifier + ", issuer = " + name + ", validity = " + validity + ", subject = " + name2 + ", spki = " + subjectPublicKeyInfo);
        PKIXUtils.verifyNotNull(aSN1Integer, algorithmIdentifier, name, validity, name2, subjectPublicKeyInfo);
        this.a = version == null ? Version.v1 : version;
        this.b = aSN1Integer;
        this.c = algorithmIdentifier;
        this.d = name;
        this.e = validity;
        this.f = name2;
        this.g = subjectPublicKeyInfo;
    }

    public Version getVersion() {
        return this.a;
    }

    public void setVersion(Version version) {
        this.a = version;
    }

    public ASN1Integer getSerialNumber() {
        return this.b;
    }

    public void setSerialNumber(ASN1Integer aSN1Integer) {
        this.b = aSN1Integer;
    }

    public AlgorithmIdentifier getSignatureAlgId() {
        return this.c;
    }

    public void setSignatureAlgId(AlgorithmIdentifier algorithmIdentifier) {
        this.c = algorithmIdentifier;
    }

    public Name getIssuer() {
        return this.d;
    }

    public void setIssuer(Name name) {
        this.d = name;
    }

    public Validity getValidity() {
        return this.e;
    }

    public void setValidity(Validity validity) {
        this.e = validity;
    }

    public Name getSubject() {
        return this.f;
    }

    public void setSubject(Name name) {
        this.f = name;
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.g;
    }

    public void setSubjectPublicKeyInfo(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.g = subjectPublicKeyInfo;
    }

    public void setIssuerUID(ASN1BitString aSN1BitString) {
        this.debug("issuerUID = " + aSN1BitString);
        this.h = aSN1BitString;
    }

    public boolean hasIssuerUID() {
        return this.h != null;
    }

    public ASN1BitString getIssuerUID() {
        return this.h;
    }

    public void setSubjectUID(ASN1BitString aSN1BitString) {
        this.debug("subjectUID = " + aSN1BitString);
        this.i = aSN1BitString;
    }

    public boolean hasSubjectUID() {
        return this.i != null;
    }

    public ASN1BitString getSubjectUID() {
        return this.i;
    }

    public boolean hasExtensions() {
        return this.j != null && !this.j.isEmpty();
    }

    public void setExtensions(Extensions extensions) {
        this.debug("exts = " + extensions);
        this.j = extensions;
    }

    public Extensions getExtensions() {
        return this.j;
    }

    public void addExtension(Extension extension) {
        this.debug("ext = " + extension);
        PKIXUtils.verifyNotNull(extension);
        if (this.j == null) {
            this.j = new Extensions(extension);
            return;
        }
        this.j.addElement(extension);
    }

    public List<BaseExtension> getDecodedList() throws DecodeExtensionException {
        if (this.j == null) {
            return null;
        }
        return this.j.getDecoded();
    }

    public boolean isExtensionPresent(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        this.debug("oid = " + aSN1ObjectIdentifier);
        return this.getExtension(aSN1ObjectIdentifier) != null;
    }

    public Extension getExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        this.debug("oid = " + aSN1ObjectIdentifier);
        if (this.j == null) {
            return null;
        }
        return this.j.getExtension(aSN1ObjectIdentifier);
    }

    public Set<String> getExtensionOIDs(boolean bl) {
        this.debug("isCritical = " + bl);
        HashSet<String> hashSet = new HashSet<String>();
        if (this.j != null) {
            int n = this.j.size();
            for (int i = 0; i < n; ++i) {
                Extension extension = (Extension)this.j.elementAt(i);
                if (extension.isCritical() != bl) continue;
                hashSet.add(extension.getOID().toString());
            }
        }
        return hashSet;
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        if (this.a != Version.v1) {
            aSN1Sequence.addElement((ASN1Value)new ASN1Explicit(ASN1Tag.get((long)0L), (ASN1Value)this.a.getASNValue()));
        }
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.addElement((ASN1Value)this.c);
        aSN1Sequence.addElement((ASN1Value)this.d);
        aSN1Sequence.addElement((ASN1Value)this.e);
        aSN1Sequence.addElement((ASN1Value)this.f);
        aSN1Sequence.addElement((ASN1Value)this.g);
        aSN1Sequence.addOptionalElement(ASN1Tag.get((long)1L), (ASN1Value)this.h);
        aSN1Sequence.addOptionalElement(ASN1Tag.get((long)1L), (ASN1Value)this.h);
        aSN1Sequence.addOptionalExplicitElement(ASN1Tag.get((long)3L), (ASN1Value)this.j);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    public String toString() {
        return "TBSCertificate [version=" + (Object)((Object)this.a) + ", serialNumber=" + this.b + ", signatureAlgId=" + this.c + ", issuer=" + this.d + ", validity=" + this.e + ", subject=" + this.f + ", spki=" + this.g + ", issuerUID=" + this.h + ", subjectUID=" + this.i + ", extensions=" + this.j + "]";
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            ASN1Explicit.Template template = ASN1Explicit.getTemplate((ASN1Tag)ASN1Tag.get((long)0L), (ASN1Template)ASN1Integer.TEMPLATE);
            ASN1Explicit aSN1Explicit = new ASN1Explicit(ASN1Tag.get((long)0L), (ASN1Value)Version.v1.getASNValue());
            this.seqt.addElement((ASN1Template)template, (ASN1Value)aSN1Explicit);
            this.seqt.addElement(ASN1Integer.TEMPLATE);
            this.seqt.addElement(AlgorithmIdentifier.TEMPLATE);
            this.seqt.addElement(Name.TEMPLATE);
            this.seqt.addElement(Validity.TEMPLATE);
            this.seqt.addElement(Name.TEMPLATE);
            this.seqt.addElement(SubjectPublicKeyInfo.TEMPLATE);
            this.seqt.addOptionalElement(ASN1Tag.get((long)1L), ASN1BitString.TEMPLATE);
            this.seqt.addOptionalElement(ASN1Tag.get((long)2L), ASN1BitString.TEMPLATE);
            this.seqt.addOptionalElement((ASN1Template)new ASN1Explicit.Template(ASN1Tag.get((long)3L), Extensions.TEMPLATE));
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream object) throws InvalidBERException, IOException {
            object = (object = (ASN1Explicit)(aSN1Tag = this.getSequence(aSN1Tag, (InputStream)object)).elementAt(0)) == null ? Version.v1 : Version.fromASNInt((ASN1Integer)object.getContent());
            ASN1Integer aSN1Integer = (ASN1Integer)aSN1Tag.elementAt(1);
            AlgorithmIdentifier algorithmIdentifier = (AlgorithmIdentifier)aSN1Tag.elementAt(2);
            Name name = (Name)aSN1Tag.elementAt(3);
            Validity validity = (Validity)aSN1Tag.elementAt(4);
            Name name2 = (Name)aSN1Tag.elementAt(5);
            SubjectPublicKeyInfo subjectPublicKeyInfo = (SubjectPublicKeyInfo)aSN1Tag.elementAt(6);
            ASN1BitString aSN1BitString = (ASN1BitString)aSN1Tag.elementAt(7);
            ASN1BitString aSN1BitString2 = (ASN1BitString)aSN1Tag.elementAt(8);
            aSN1Tag = (ASN1Explicit)aSN1Tag.elementAt(9);
            aSN1Tag = aSN1Tag == null ? null : (Extensions)aSN1Tag.getContent();
            object = new TBSCertificate((Version)((Object)object), aSN1Integer, algorithmIdentifier, name, validity, name2, subjectPublicKeyInfo);
            ((TBSCertificate)object).setIssuerUID(aSN1BitString);
            ((TBSCertificate)object).setSubjectUID(aSN1BitString2);
            ((TBSCertificate)object).setExtensions((Extensions)aSN1Tag);
            return object;
        }
    }
}

