/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509;

import com.bifit.security.asn1.ASN1Integer;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.primitive.Time;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.Extensions;
import com.bifit.security.pkix.x509.ext.CRLReason;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;

public class RevokedCertificate
extends AbstractASN1Sequence {
    private ASN1Integer a;
    private Time b;
    private Extensions c;
    public static final ASN1Template TEMPLATE = new a();

    public RevokedCertificate(ASN1Integer object) {
        super(RevokedCertificate.class);
        PKIXUtils.verifyNotNull(object);
        this.a = object;
        object = Calendar.getInstance();
        ((Calendar)object).set(14, 0);
        object = ((Calendar)object).getTime();
        this.b = new Time((Date)object);
        this.c = null;
    }

    public RevokedCertificate(ASN1Integer aSN1Integer, Time time) {
        super(RevokedCertificate.class);
        PKIXUtils.verifyNotNull(aSN1Integer, time);
        this.a = aSN1Integer;
        this.b = time;
    }

    public ASN1Integer getCertSN() {
        return this.a;
    }

    public void setCertSN(ASN1Integer aSN1Integer) {
        PKIXUtils.verifyNotNull(aSN1Integer);
        this.a = aSN1Integer;
    }

    public Time getRevocationDate() {
        return this.b;
    }

    public void setRevocationDate(Time time) {
        this.b = time;
    }

    public Extensions getExtensions() {
        return this.c;
    }

    public void setExtensions(Extensions extensions) {
        this.c = extensions;
    }

    public CRLReason getReason() {
        if (this.c == null) {
            return null;
        }
        try {
            return (CRLReason)this.c.getDecoded(CRLReason.OID);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static RevokedCertificate getInstance(byte[] byArray) throws PKIXException {
        try {
            return (RevokedCertificate)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.addOptionalElement((ASN1Value)this.c);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    public String toString() {
        return "RevokedCertificate [certSN=" + this.a + ", revocationDate=" + this.b.toDate() + ", extensions=" + this.c + "]";
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(ASN1Integer.TEMPLATE);
            this.seqt.addElement((ASN1Template)Time.TEMPLATE);
            this.seqt.addOptionalElement(Extensions.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag object, InputStream object2) throws IOException, InvalidBERException {
            object = (ASN1Sequence)this.seqt.decode(object, (InputStream)object2);
            object2 = (ASN1Integer)object.elementAt(0);
            Time time = (Time)object.elementAt(1);
            object = (Extensions)object.elementAt(2);
            object2 = new RevokedCertificate((ASN1Integer)object2, time);
            ((RevokedCertificate)object2).setExtensions((Extensions)object);
            return object2;
        }
    }
}

