/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509;

import com.bifit.security.asn1.ASN1Integer;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.DisplayText;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class NoticeReference
extends AbstractASN1Sequence {
    private final DisplayText a;
    private final ASN1Sequence b;
    public static final ASN1Template TEMPLATE = new a();

    public NoticeReference(DisplayText displayText, ASN1Sequence aSN1Sequence) throws IOException {
        super(NoticeReference.class);
        PKIXUtils.verifyNotNull(displayText);
        this.a = displayText;
        PKIXUtils.verifyNotNull(aSN1Sequence);
        if (!aSN1Sequence.checkElementsType(ASN1Integer.class)) {
            throw new IOException("Invalid noticeNumbers type");
        }
        this.b = aSN1Sequence;
    }

    public static NoticeReference getInstance(byte[] byArray) throws PKIXException {
        try {
            return (NoticeReference)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    public DisplayText getOrganization() {
        return this.a;
    }

    public void addNoticeNumbers(ASN1Integer aSN1Integer) {
        this.b.addElement((ASN1Value)aSN1Integer);
    }

    public ASN1Sequence getNoticeNumbers() {
        return this.b;
    }

    public ASN1Integer getNoticeNumber(int n) {
        try {
            return (ASN1Integer)this.b.elementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(DisplayText.TEMPLATE);
            this.seqt.addElement((ASN1Template)ASN1Sequence.getSequenceTemplate((ASN1Template)ASN1Integer.TEMPLATE));
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            aSN1Tag = this.getSequence(aSN1Tag, inputStream);
            return new NoticeReference((DisplayText)aSN1Tag.elementAt(0), (ASN1Sequence)aSN1Tag.elementAt(1));
        }
    }
}

