/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509;

import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.x509.GeneralNames;
import com.bifit.security.pkix.x509.IssuerSerial;
import com.bifit.security.pkix.x509.ObjectDigestInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Holder
extends AbstractASN1Sequence {
    private final IssuerSerial a;
    private final GeneralNames b;
    private final ObjectDigestInfo c;
    public static final ASN1Template TEMPLATE = new a();

    public Holder(IssuerSerial issuerSerial, GeneralNames generalNames, ObjectDigestInfo objectDigestInfo) {
        super(Holder.class);
        this.a = issuerSerial;
        this.b = generalNames;
        this.c = objectDigestInfo;
    }

    public IssuerSerial getBaseCertificateID() {
        return this.a;
    }

    public GeneralNames getEntityName() {
        return this.b;
    }

    public ObjectDigestInfo getObjectDigestInfo() {
        return this.c;
    }

    public static Holder getInstance(byte[] byArray) throws PKIXException {
        try {
            return (Holder)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addOptionalElement(ASN1Tag.get((long)0L), (ASN1Value)this.a);
        aSN1Sequence.addOptionalElement(ASN1Tag.get((long)1L), (ASN1Value)this.b);
        aSN1Sequence.addOptionalElement(ASN1Tag.get((long)2L), (ASN1Value)this.c);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addOptionalElement(ASN1Tag.get((long)0L), IssuerSerial.TEMPLATE);
            this.seqt.addOptionalElement(ASN1Tag.get((long)1L), GeneralNames.TEMPLATE);
            this.seqt.addOptionalElement(ASN1Tag.get((long)2L), ObjectDigestInfo.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            aSN1Tag = (ASN1Sequence)this.seqt.decode(aSN1Tag, inputStream);
            return new Holder((IssuerSerial)aSN1Tag.elementAt(0), (GeneralNames)aSN1Tag.elementAt(1), (ObjectDigestInfo)aSN1Tag.elementAt(2));
        }
    }
}

