/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509;

import com.bifit.security.asn1.ASN1Boolean;
import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.asn1.ASN1OctetString;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.DecodeExtensionException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.ext.AcceptableResponses;
import com.bifit.security.pkix.x509.ext.ArchiveCutoff;
import com.bifit.security.pkix.x509.ext.AuthorityInfoAccess;
import com.bifit.security.pkix.x509.ext.AuthorityKeyIdentifier;
import com.bifit.security.pkix.x509.ext.BaseExtension;
import com.bifit.security.pkix.x509.ext.BasicConstraints;
import com.bifit.security.pkix.x509.ext.CRLDistributionPoints;
import com.bifit.security.pkix.x509.ext.CRLNumber;
import com.bifit.security.pkix.x509.ext.CRLReason;
import com.bifit.security.pkix.x509.ext.CertificateIssuer;
import com.bifit.security.pkix.x509.ext.CertificatePolicies;
import com.bifit.security.pkix.x509.ext.CrlID;
import com.bifit.security.pkix.x509.ext.DeltaCRLIndicator;
import com.bifit.security.pkix.x509.ext.ExtKeyUsage;
import com.bifit.security.pkix.x509.ext.FreshestCRL;
import com.bifit.security.pkix.x509.ext.HoldInstructionCode;
import com.bifit.security.pkix.x509.ext.InvalidityDate;
import com.bifit.security.pkix.x509.ext.IssuerAltName;
import com.bifit.security.pkix.x509.ext.KeyUsage;
import com.bifit.security.pkix.x509.ext.Nonce;
import com.bifit.security.pkix.x509.ext.PrivateKeyUsagePeriod;
import com.bifit.security.pkix.x509.ext.QCStatements;
import com.bifit.security.pkix.x509.ext.ServiceLocator;
import com.bifit.security.pkix.x509.ext.SubjectAltName;
import com.bifit.security.pkix.x509.ext.SubjectDirectoryAttributes;
import com.bifit.security.pkix.x509.ext.SubjectInfoAccess;
import com.bifit.security.pkix.x509.ext.SubjectKeyIdentifier;
import com.bifit.security.pkix.x509.ext.UnsupportedExtension;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Extension
extends AbstractASN1Sequence {
    private ASN1ObjectIdentifier a;
    private boolean b;
    private ASN1OctetString c;
    public static final ASN1Template TEMPLATE = new a();

    public Extension(ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl, ASN1OctetString aSN1OctetString) {
        super(Extension.class);
        PKIXUtils.verifyNotNull(aSN1ObjectIdentifier, aSN1OctetString);
        this.a = aSN1ObjectIdentifier;
        this.b = bl;
        this.c = aSN1OctetString;
    }

    public void setOID(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        this.a = aSN1ObjectIdentifier;
    }

    public void setCritical(boolean bl) {
        this.b = bl;
    }

    public void setExtnValue(ASN1OctetString aSN1OctetString) {
        this.c = aSN1OctetString;
    }

    public ASN1ObjectIdentifier getOID() {
        return this.a;
    }

    public boolean isCritical() {
        return this.b;
    }

    public ASN1OctetString getExtnValue() {
        return this.c;
    }

    public byte[] getContent() {
        return this.c.toByteArray();
    }

    public BaseExtension getDecoded() throws DecodeExtensionException {
        try {
            if (this.a.equals((Object)AuthorityInfoAccess.OID)) {
                return new AuthorityInfoAccess(this);
            }
            if (this.a.equals((Object)AuthorityKeyIdentifier.OID)) {
                return new AuthorityKeyIdentifier(this);
            }
            if (this.a.equals((Object)BasicConstraints.OID)) {
                return new BasicConstraints(this);
            }
            if (this.a.equals((Object)CertificatePolicies.OID)) {
                return new CertificatePolicies(this);
            }
            if (this.a.equals((Object)CRLDistributionPoints.OID)) {
                return new CRLDistributionPoints(this);
            }
            if (this.a.equals((Object)ExtKeyUsage.OID)) {
                return new ExtKeyUsage(this);
            }
            if (this.a.equals((Object)FreshestCRL.OID)) {
                return new FreshestCRL(this);
            }
            if (this.a.equals((Object)IssuerAltName.OID)) {
                return new IssuerAltName(this);
            }
            if (this.a.equals((Object)KeyUsage.OID)) {
                return new KeyUsage(this);
            }
            if (this.a.equals((Object)PrivateKeyUsagePeriod.OID)) {
                return new PrivateKeyUsagePeriod(this);
            }
            if (this.a.equals((Object)QCStatements.OID)) {
                return new QCStatements(this);
            }
            if (this.a.equals((Object)SubjectAltName.OID)) {
                return new SubjectAltName(this);
            }
            if (this.a.equals((Object)SubjectDirectoryAttributes.OID)) {
                return new SubjectDirectoryAttributes(this);
            }
            if (this.a.equals((Object)SubjectInfoAccess.OID)) {
                return new SubjectInfoAccess(this);
            }
            if (this.a.equals((Object)SubjectKeyIdentifier.OID)) {
                return new SubjectKeyIdentifier(this);
            }
            if (this.a.equals((Object)CertificateIssuer.OID)) {
                return new CertificateIssuer(this);
            }
            if (this.a.equals((Object)CRLNumber.OID)) {
                return new CRLNumber(this);
            }
            if (this.a.equals((Object)CRLReason.OID)) {
                return new CRLReason(this);
            }
            if (this.a.equals((Object)DeltaCRLIndicator.OID)) {
                return new DeltaCRLIndicator(this);
            }
            if (this.a.equals((Object)HoldInstructionCode.OID)) {
                return new HoldInstructionCode(this);
            }
            if (this.a.equals((Object)InvalidityDate.OID)) {
                return new InvalidityDate(this);
            }
            if (this.a.equals((Object)AcceptableResponses.OID)) {
                return new AcceptableResponses(this);
            }
            if (this.a.equals((Object)ArchiveCutoff.OID)) {
                return new ArchiveCutoff(this);
            }
            if (this.a.equals((Object)CrlID.OID)) {
                return new CrlID(this);
            }
            if (this.a.equals((Object)Nonce.OID)) {
                return new Nonce(this);
            }
            if (this.a.equals((Object)ServiceLocator.OID)) {
                return new ServiceLocator(this);
            }
            this.warn("NO_DECODER = " + this.a);
            return new UnsupportedExtension(this);
        }
        catch (Exception exception) {
            throw new DecodeExtensionException(exception);
        }
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        if (this.b) {
            aSN1Sequence.addElement((ASN1Value)new ASN1Boolean(true));
        }
        aSN1Sequence.addElement((ASN1Value)this.c);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    public static Extension getInstance(byte[] byArray) throws PKIXException {
        try {
            return (Extension)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    public String toString() {
        return "Extension [extnId=" + this.a + ", critical=" + this.b + ", extnValue=" + this.c + "]";
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(ASN1ObjectIdentifier.TEMPLATE);
            this.seqt.addElement(ASN1Boolean.TEMPLATE, (ASN1Value)new ASN1Boolean(false));
            this.seqt.addElement(ASN1OctetString.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            aSN1Tag = this.getSequence(aSN1Tag, inputStream);
            inputStream = (ASN1ObjectIdentifier)aSN1Tag.elementAt(0);
            ASN1Boolean aSN1Boolean = (ASN1Boolean)aSN1Tag.elementAt(1);
            aSN1Tag = (ASN1OctetString)aSN1Tag.elementAt(2);
            return new Extension((ASN1ObjectIdentifier)inputStream, aSN1Boolean.toBoolean(), (ASN1OctetString)aSN1Tag);
        }
    }
}

