/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.tsp;

import com.bifit.security.asn1.ASN1Boolean;
import com.bifit.security.asn1.ASN1Explicit;
import com.bifit.security.asn1.ASN1GeneralizedTime;
import com.bifit.security.asn1.ASN1Integer;
import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.cms.EncapsulatedContentInfo;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.tsp.Accuracy;
import com.bifit.security.pkix.tsp.MessageImprint;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.Extensions;
import com.bifit.security.pkix.x509.GeneralName;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TSTInfo
extends AbstractASN1Sequence {
    private final ASN1Integer a = new ASN1Integer(1L);
    private ASN1ObjectIdentifier b;
    private MessageImprint c;
    private ASN1Integer d;
    private ASN1GeneralizedTime e;
    private Accuracy f;
    private ASN1Integer g;
    private GeneralName h;
    private Extensions i;
    public static final ASN1ObjectIdentifier OID = new ASN1ObjectIdentifier("1.2.840.113549.1.9.16.1.4");
    public static final ASN1Template TEMPLATE = new a();

    public TSTInfo(ASN1ObjectIdentifier aSN1ObjectIdentifier, MessageImprint messageImprint, ASN1Integer aSN1Integer, ASN1GeneralizedTime aSN1GeneralizedTime) {
        super(TSTInfo.class);
        this.debug("policy = " + aSN1ObjectIdentifier + ", messageImprint = " + messageImprint + ", serialNumber = " + aSN1Integer + ", genTime = " + aSN1GeneralizedTime);
        PKIXUtils.verifyNotNull(aSN1ObjectIdentifier, messageImprint, aSN1Integer, aSN1GeneralizedTime);
        this.b = aSN1ObjectIdentifier;
        this.c = messageImprint;
        this.d = aSN1Integer;
        this.e = aSN1GeneralizedTime;
    }

    public ASN1ObjectIdentifier getPolicy() {
        return this.b;
    }

    public void setPolicy(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        this.debug("policy = " + aSN1ObjectIdentifier);
        PKIXUtils.verifyNotNull(aSN1ObjectIdentifier);
        this.b = aSN1ObjectIdentifier;
    }

    public MessageImprint getMessageImprint() {
        return this.c;
    }

    public void setMessageImprint(MessageImprint messageImprint) {
        this.debug("messageImprint = " + messageImprint);
        PKIXUtils.verifyNotNull(messageImprint);
        this.c = messageImprint;
    }

    public ASN1Integer getSerialNumber() {
        return this.d;
    }

    public void setSerialNumber(ASN1Integer aSN1Integer) {
        this.debug("serialNumber = " + aSN1Integer);
        PKIXUtils.verifyNotNull(aSN1Integer);
        this.d = aSN1Integer;
    }

    public ASN1GeneralizedTime getGenTime() {
        return this.e;
    }

    public void setGenTime(ASN1GeneralizedTime aSN1GeneralizedTime) {
        this.debug("genTime = " + aSN1GeneralizedTime);
        PKIXUtils.verifyNotNull(aSN1GeneralizedTime);
        this.e = aSN1GeneralizedTime;
    }

    public Accuracy getAccuracy() {
        return this.f;
    }

    public void setAccuracy(Accuracy accuracy) {
        this.debug("accuracy = " + accuracy);
        this.f = accuracy;
    }

    public ASN1Integer getNonce() {
        return this.g;
    }

    public void setNonce(ASN1Integer aSN1Integer) {
        this.debug("nonce = " + aSN1Integer);
        this.g = aSN1Integer;
    }

    public GeneralName getTSAuthority() {
        return this.h;
    }

    public void setTSAuthority(GeneralName generalName) {
        this.debug("tsa = " + generalName);
        this.h = generalName;
    }

    public Extensions getExts() {
        return this.i;
    }

    public void setExts(Extensions extensions) {
        this.debug("exts = " + extensions);
        this.i = extensions;
    }

    public ASN1Integer getVersion() {
        return this.a;
    }

    public EncapsulatedContentInfo toContentInfo() {
        EncapsulatedContentInfo encapsulatedContentInfo = new EncapsulatedContentInfo(OID);
        encapsulatedContentInfo.setContent(this);
        return encapsulatedContentInfo;
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.addElement((ASN1Value)this.c);
        aSN1Sequence.addElement((ASN1Value)this.d);
        aSN1Sequence.addElement((ASN1Value)this.e);
        aSN1Sequence.addOptionalElement((ASN1Value)this.f);
        aSN1Sequence.addOptionalElement((ASN1Value)this.g);
        aSN1Sequence.addOptionalExplicitElement(ASN1Tag.get((long)0L), (ASN1Value)this.h);
        aSN1Sequence.addOptionalElement(ASN1Tag.get((long)1L), (ASN1Value)this.i);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(ASN1Integer.TEMPLATE);
            this.seqt.addElement(ASN1ObjectIdentifier.TEMPLATE);
            this.seqt.addElement(MessageImprint.TEMPLATE);
            this.seqt.addElement(ASN1Integer.TEMPLATE);
            this.seqt.addElement(ASN1GeneralizedTime.TEMPLATE);
            this.seqt.addOptionalElement(Accuracy.TEMPLATE);
            this.seqt.addElement(ASN1Boolean.TEMPLATE, (ASN1Value)new ASN1Boolean(false));
            this.seqt.addOptionalElement(ASN1Integer.TEMPLATE);
            this.seqt.addOptionalElement((ASN1Template)ASN1Explicit.getTemplate((ASN1Tag)ASN1Tag.get((long)0L), (ASN1Template)GeneralName.TEMPLATE));
            this.seqt.addOptionalElement(ASN1Tag.get((long)1L), Extensions.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag object, InputStream object2) throws IOException, InvalidBERException {
            object = this.getSequence((ASN1Tag)object, (InputStream)object2);
            object2 = (ASN1Integer)object.elementAt(0);
            PKIXUtils.compareVersion(1, object2.intValue());
            object2 = (ASN1ObjectIdentifier)object.elementAt(1);
            MessageImprint messageImprint = (MessageImprint)object.elementAt(2);
            ASN1Integer aSN1Integer = (ASN1Integer)object.elementAt(3);
            ASN1GeneralizedTime aSN1GeneralizedTime = (ASN1GeneralizedTime)object.elementAt(4);
            Accuracy accuracy = (Accuracy)object.elementAt(5);
            object.elementAt(6);
            ASN1Integer aSN1Integer2 = (ASN1Integer)object.elementAt(7);
            ASN1Explicit aSN1Explicit = (ASN1Explicit)object.elementAt(8);
            object = (Extensions)object.elementAt(9);
            object2 = new TSTInfo((ASN1ObjectIdentifier)object2, messageImprint, aSN1Integer, aSN1GeneralizedTime);
            ((TSTInfo)object2).setAccuracy(accuracy);
            ((TSTInfo)object2).setNonce(aSN1Integer2);
            ((TSTInfo)object2).setTSAuthority((GeneralName)(aSN1Explicit == null ? null : aSN1Explicit.getContent()));
            ((TSTInfo)object2).setExts((Extensions)object);
            return object2;
        }
    }
}

