/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.tsp;

import com.bifit.security.asn1.ASN1OctetString;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.crypto.DigestAdapter;
import com.bifit.security.pkix.exception.CryptoException;
import com.bifit.security.pkix.log.LogKey;
import com.bifit.security.pkix.log.LogParam;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.AlgorithmIdentifier;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MessageImprint
extends AbstractASN1Sequence {
    private AlgorithmIdentifier a;
    private ASN1OctetString b;
    public static final ASN1Template TEMPLATE = new a();

    public MessageImprint(AlgorithmIdentifier algorithmIdentifier, ASN1OctetString aSN1OctetString) {
        super(MessageImprint.class);
        LogParam logParam = new LogParam(LogKey.HASH_ALG, algorithmIdentifier.getAlgorithm());
        LogParam logParam2 = new LogParam(LogKey.HASH, PKIXUtils.arrayToString(aSN1OctetString.toByteArray()));
        this.debug(LogParam.print(logParam, logParam2));
        PKIXUtils.verifyNotNull(algorithmIdentifier, aSN1OctetString);
        this.a = algorithmIdentifier;
        this.b = aSN1OctetString;
    }

    public MessageImprint(byte[] byArray, DigestAdapter digestAdapter) throws CryptoException {
        super(MessageImprint.class);
        this.a = digestAdapter.getDigestAlgorithm();
        this.b = new ASN1OctetString(digestAdapter.digest(byArray));
    }

    public AlgorithmIdentifier getHashAlgorithm() {
        return this.a;
    }

    public void setHashAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
        this.debug("HASH_ALG = " + algorithmIdentifier.getAlgorithm());
        PKIXUtils.verifyNotNull(algorithmIdentifier);
        this.a = algorithmIdentifier;
    }

    public ASN1OctetString getHashedMessage() {
        return this.b;
    }

    public void setHashedMessage(ASN1OctetString aSN1OctetString) {
        this.debug("HASH = " + PKIXUtils.arrayToString(aSN1OctetString.toByteArray()));
        PKIXUtils.verifyNotNull(aSN1OctetString);
        this.b = aSN1OctetString;
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    public String toString() {
        return "MessageImprint [hashAlgorithm=" + this.a + ", hashedMessage=" + this.b + "]";
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(AlgorithmIdentifier.TEMPLATE);
            this.seqt.addElement(ASN1OctetString.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream object) throws IOException, InvalidBERException {
            aSN1Tag = (ASN1Sequence)this.seqt.decode(aSN1Tag, (InputStream)object);
            object = (AlgorithmIdentifier)aSN1Tag.elementAt(0);
            aSN1Tag = (ASN1OctetString)aSN1Tag.elementAt(1);
            return new MessageImprint((AlgorithmIdentifier)object, (ASN1OctetString)aSN1Tag);
        }
    }
}

