/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.primitive;

import com.bifit.security.asn1.ASN1OctetString;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.utils.PKIXUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class GOST28147Parameters
extends AbstractASN1Sequence {
    private final ASN1OctetString a;
    private final ASN1OctetString b;
    public static final ASN1Template TEMPLATE = new a();

    public GOST28147Parameters(ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2) {
        super(GOST28147Parameters.class);
        this.debug("iv = " + aSN1OctetString + "dke = " + aSN1OctetString2);
        PKIXUtils.verifyNotNull(aSN1OctetString, aSN1OctetString2);
        this.a = aSN1OctetString;
        this.b = aSN1OctetString2;
    }

    public ASN1OctetString getIV() {
        return this.a;
    }

    public ASN1OctetString getDKE() {
        return this.b;
    }

    public static GOST28147Parameters getInstance(byte[] byArray) throws PKIXException {
        try {
            return (GOST28147Parameters)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(ASN1OctetString.TEMPLATE);
            this.seqt.addElement(ASN1OctetString.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws InvalidBERException, IOException {
            aSN1Tag = this.getSequence(aSN1Tag, inputStream);
            return new GOST28147Parameters((ASN1OctetString)aSN1Tag.elementAt(0), (ASN1OctetString)aSN1Tag.elementAt(1));
        }
    }
}

