/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.primitive;

import com.bifit.security.asn1.ASN1Explicit;
import com.bifit.security.asn1.ASN1Integer;
import com.bifit.security.asn1.ASN1OctetString;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.primitive.BinaryField;
import com.bifit.security.pkix.utils.PKIXUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ECBinary
extends AbstractASN1Sequence {
    private final ASN1Integer a;
    private final BinaryField b;
    private final ASN1Integer c;
    private final ASN1OctetString d;
    private final ASN1Integer e;
    private final ASN1OctetString f;
    public static final ASN1Template TEMPLATE = new a();

    public ECBinary(BinaryField binaryField, ASN1Integer aSN1Integer, ASN1OctetString aSN1OctetString, ASN1Integer aSN1Integer2, ASN1OctetString aSN1OctetString2) {
        this(null, binaryField, aSN1Integer, aSN1OctetString, aSN1Integer2, aSN1OctetString2);
    }

    public ECBinary(ASN1Integer aSN1Integer, BinaryField binaryField, ASN1Integer aSN1Integer2, ASN1OctetString aSN1OctetString, ASN1Integer aSN1Integer3, ASN1OctetString aSN1OctetString2) {
        super(ECBinary.class);
        this.debug("version = " + aSN1Integer + ", f = " + binaryField + ", a = " + aSN1Integer2 + ", b = " + aSN1OctetString + ", n = " + aSN1Integer3 + ", bp = " + aSN1OctetString2);
        PKIXUtils.verifyNotNull(binaryField, aSN1Integer2, aSN1OctetString, aSN1Integer3, aSN1OctetString2);
        this.a = aSN1Integer == null ? new ASN1Integer(0L) : aSN1Integer;
        this.b = binaryField;
        this.c = aSN1Integer2;
        this.d = aSN1OctetString;
        this.e = aSN1Integer3;
        this.f = aSN1OctetString2;
    }

    public ASN1Integer getVersion() {
        return this.a;
    }

    public BinaryField getF() {
        return this.b;
    }

    public ASN1Integer getA() {
        return this.c;
    }

    public ASN1OctetString getB() {
        return this.d;
    }

    public ASN1Integer getN() {
        return this.e;
    }

    public ASN1OctetString getBp() {
        return this.f;
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        if (this.a != null && this.a.intValue() != 0) {
            aSN1Sequence.addElement((ASN1Value)new ASN1Explicit(ASN1Tag.get((long)0L), (ASN1Value)this.a));
        }
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.addElement((ASN1Value)this.c);
        aSN1Sequence.addElement((ASN1Value)this.d);
        aSN1Sequence.addElement((ASN1Value)this.e);
        aSN1Sequence.addElement((ASN1Value)this.f);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    public static ECBinary getInstance(byte[] byArray) throws PKIXException {
        try {
            return (ECBinary)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    public String toString() {
        return "ECBinary [version=" + this.a + ", f=" + this.b + ", a=" + this.c + ", b=" + this.d + ", n=" + this.e + ", bp=" + this.f + "]";
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            ASN1Explicit aSN1Explicit = new ASN1Explicit(ASN1Tag.get((long)0L), (ASN1Value)new ASN1Integer(0L));
            this.seqt.addElement((ASN1Template)ASN1Explicit.getTemplate((ASN1Tag)ASN1Tag.get((long)0L), (ASN1Template)ASN1Integer.TEMPLATE), (ASN1Value)aSN1Explicit);
            this.seqt.addElement(BinaryField.TEMPLATE);
            this.seqt.addElement(ASN1Integer.TEMPLATE);
            this.seqt.addElement(ASN1OctetString.TEMPLATE);
            this.seqt.addElement(ASN1Integer.TEMPLATE);
            this.seqt.addElement(ASN1OctetString.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            aSN1Tag = this.getSequence(aSN1Tag, inputStream);
            inputStream = (ASN1Explicit)aSN1Tag.elementAt(0);
            inputStream = (ASN1Integer)inputStream.getContent();
            BinaryField binaryField = (BinaryField)aSN1Tag.elementAt(1);
            ASN1Integer aSN1Integer = (ASN1Integer)aSN1Tag.elementAt(2);
            ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1Tag.elementAt(3);
            ASN1Integer aSN1Integer2 = (ASN1Integer)aSN1Tag.elementAt(4);
            aSN1Tag = (ASN1OctetString)aSN1Tag.elementAt(5);
            return new ECBinary((ASN1Integer)inputStream, binaryField, aSN1Integer, aSN1OctetString, aSN1Integer2, (ASN1OctetString)aSN1Tag);
        }
    }
}

