/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.pkcs10;

import com.bifit.security.asn1.ASN1Integer;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Set;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.primitive.Attribute;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.Name;
import com.bifit.security.pkix.x509.SubjectPublicKeyInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PublicKey;

public class CertificationRequestInfo
extends AbstractASN1Sequence {
    private final ASN1Integer a;
    private final Name b;
    private final SubjectPublicKeyInfo c;
    private final ASN1Set d;
    public static final ASN1Template TEMPLATE = new a();

    public CertificationRequestInfo(Name name, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        super(CertificationRequestInfo.class);
        this.debug("subject = " + name + ", subPubKeyInfo = " + subjectPublicKeyInfo);
        PKIXUtils.verifyNotNull(name, subjectPublicKeyInfo);
        this.a = new ASN1Integer(0L);
        this.b = name;
        this.c = subjectPublicKeyInfo;
        this.d = new ASN1Set();
    }

    public CertificationRequestInfo(Name name, PublicKey publicKey) throws InvalidBERException {
        this(name, new SubjectPublicKeyInfo(publicKey));
    }

    CertificationRequestInfo(ASN1Integer aSN1Integer, Name name, SubjectPublicKeyInfo subjectPublicKeyInfo, ASN1Set aSN1Set) {
        super(CertificationRequestInfo.class);
        this.debug("version=" + aSN1Integer + ", subject=" + name + ", subPubKeyInfo=" + subjectPublicKeyInfo + ", attributes=" + aSN1Set);
        PKIXUtils.verifyNotNull(aSN1Integer, name, subjectPublicKeyInfo);
        this.a = aSN1Integer;
        this.b = name;
        this.c = subjectPublicKeyInfo;
        this.d = aSN1Set;
    }

    public ASN1Integer getVersion() {
        return this.a;
    }

    public Name getName() {
        return this.b;
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.c;
    }

    public void addAttribute(Attribute attribute) {
        this.debug("attr = " + attribute);
        this.d.addElement((ASN1Value)attribute);
    }

    public Attribute attributeAt(int n) {
        this.debug("INDEX = " + n);
        return (Attribute)this.d.elementAt(n);
    }

    public void insertAttributeAt(Attribute attribute, int n) {
        this.debug("attr = " + attribute + ", index = " + n);
        this.d.insertElementAt((ASN1Value)attribute, n);
    }

    public void removeAllAttributes() {
        this.d.removeAllElements();
    }

    public int attributesSize() {
        return this.d.size();
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.addElement((ASN1Value)this.c);
        aSN1Sequence.addElement(ASN1Tag.get((long)0L), (ASN1Value)this.d);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    public static CertificationRequestInfo getInstance(byte[] byArray) throws PKIXException {
        try {
            return (CertificationRequestInfo)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    public String toString() {
        return "CertificationRequestInfo [version=" + this.a + ", subject=" + this.b + ", subjectPKInfo=" + this.c + ", attributes=" + this.d + "]";
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(ASN1Integer.TEMPLATE);
            this.seqt.addElement(Name.TEMPLATE);
            this.seqt.addElement(SubjectPublicKeyInfo.TEMPLATE);
            this.seqt.addElement(ASN1Tag.get((long)0L), (ASN1Template)new ASN1Set.OF_Template(Attribute.TEMPLATE));
        }

        @Override
        public final ASN1Value decode(ASN1Tag object, InputStream inputStream) throws InvalidBERException, IOException {
            object = (ASN1Sequence)this.seqt.decode(object, inputStream);
            object = new CertificationRequestInfo((ASN1Integer)object.elementAt(0), (Name)object.elementAt(1), (SubjectPublicKeyInfo)object.elementAt(2), (ASN1Set)object.elementAt(3));
            return object;
        }
    }
}

