/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.ocsp;

import com.bifit.security.asn1.ASN1Enumerated;
import com.bifit.security.asn1.ASN1Explicit;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.ocsp.ResponseBytes;
import com.bifit.security.pkix.ocsp.ResponseStatus;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.utils.PKIXUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class OCSPResponse
extends AbstractASN1Sequence {
    private ResponseStatus a;
    private ResponseBytes b;
    public static final ASN1Template TEMPLATE = new a();

    public OCSPResponse(ResponseStatus responseStatus) {
        super(OCSPResponse.class);
        this.debug("status = " + (Object)((Object)responseStatus));
        PKIXUtils.verifyNotNull(new Object[]{responseStatus});
        this.a = responseStatus;
    }

    public ResponseStatus getStatus() {
        return this.a;
    }

    public void setStatus(ResponseStatus responseStatus) {
        this.debug("status = " + (Object)((Object)responseStatus));
        PKIXUtils.verifyNotNull(new Object[]{responseStatus});
        if (responseStatus == ResponseStatus.SUCCESSFUL && this.b == null) {
            throw new IllegalStateException("SUCCESSFUL must contain response info");
        }
        this.a = responseStatus;
    }

    public ResponseBytes getBytes() {
        return this.b;
    }

    public void setBytes(ResponseBytes responseBytes) {
        if (this.a == ResponseStatus.SUCCESSFUL && responseBytes == null) {
            throw new IllegalStateException("SUCCESSFUL must contain response info");
        }
        this.b = responseBytes;
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a.getEnum());
        if (this.a == ResponseStatus.SUCCESSFUL) {
            aSN1Sequence.addElement((ASN1Value)new ASN1Explicit(ASN1Tag.get((long)0L), (ASN1Value)this.b));
        }
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    public static OCSPResponse getInstance(byte[] byArray) throws PKIXException {
        try {
            return (OCSPResponse)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    public static OCSPResponse getInstance(File file) throws IOException {
        try {
            return OCSPResponse.getInstance(PKIXUtils.readFile(file));
        }
        catch (PKIXException pKIXException) {
            throw new IOException("Error reading OCSP response", pKIXException);
        }
    }

    public String toString() {
        return "OCSPResponse [status=" + (Object)((Object)this.a) + ", bytes=" + this.b + "]";
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(ASN1Enumerated.TEMPLATE);
            this.seqt.addOptionalElement((ASN1Template)ASN1Explicit.getTemplate((ASN1Tag)ASN1Tag.get((long)0L), (ASN1Template)ResponseBytes.TEMPLATE));
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream object) throws IOException, InvalidBERException {
            aSN1Tag = this.getSequence(aSN1Tag, (InputStream)object);
            object = ResponseStatus.fromEnum((ASN1Enumerated)aSN1Tag.elementAt(0));
            aSN1Tag = (ASN1Explicit)aSN1Tag.elementAt(1);
            object = new OCSPResponse((ResponseStatus)((Object)object));
            ((OCSPResponse)object).setBytes(aSN1Tag == null ? null : (ResponseBytes)aSN1Tag.getContent());
            return object;
        }
    }
}

