/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.ocsp;

import com.bifit.security.asn1.ASN1Integer;
import com.bifit.security.asn1.ASN1OctetString;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.crypto.DigestAdapter;
import com.bifit.security.pkix.exception.CryptoException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.AlgorithmIdentifier;
import com.bifit.security.pkix.x509.Certificate;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CertID
extends AbstractASN1Sequence {
    private AlgorithmIdentifier a;
    private ASN1OctetString b;
    private ASN1OctetString c;
    private ASN1Integer d;
    public static final ASN1Template TEMPLATE = new a();

    public CertID(AlgorithmIdentifier algorithmIdentifier, ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2, ASN1Integer aSN1Integer) {
        super(CertID.class);
        this.debug("hashAlg = " + algorithmIdentifier + ", issNameHash = " + aSN1OctetString + ", issPKHash = " + aSN1OctetString2 + ", serialNumber = " + aSN1Integer);
        PKIXUtils.verifyNotNull(algorithmIdentifier, aSN1OctetString, aSN1OctetString2, aSN1Integer);
        this.a = algorithmIdentifier;
        this.b = aSN1OctetString;
        this.c = aSN1OctetString2;
        this.d = aSN1Integer;
    }

    public CertID(DigestAdapter object, Certificate certificate, Certificate certificate2) throws CryptoException {
        super(CertID.class);
        this.debug("digestAdapter = " + object + ", issuer = " + certificate + ", subject = " + certificate2);
        PKIXUtils.verifyNotNull(object, certificate, certificate2);
        this.a = object.getDigestAlgorithm();
        byte[] byArray = object.digest(certificate.getInfo().getSubject().encode());
        object = object.digest(certificate.getInfo().getSubjectPublicKeyInfo().getPublicKeyBytes());
        this.b = new ASN1OctetString(byArray);
        this.c = new ASN1OctetString((byte[])object);
        this.d = certificate2.getInfo().getSerialNumber();
    }

    public AlgorithmIdentifier getHashAlg() {
        return this.a;
    }

    public void setHashAlg(AlgorithmIdentifier algorithmIdentifier) {
        this.debug("hashAlg = " + algorithmIdentifier);
        PKIXUtils.verifyNotNull(algorithmIdentifier);
        this.a = algorithmIdentifier;
    }

    public ASN1OctetString getIssNameHash() {
        return this.b;
    }

    public void setIssNameHash(ASN1OctetString aSN1OctetString) {
        this.debug("issNameHash = " + aSN1OctetString);
        PKIXUtils.verifyNotNull(aSN1OctetString);
        this.b = aSN1OctetString;
    }

    public ASN1OctetString getIssPKHash() {
        return this.c;
    }

    public void setIssPKHash(ASN1OctetString aSN1OctetString) {
        this.debug("issPKHash = " + aSN1OctetString);
        PKIXUtils.verifyNotNull(aSN1OctetString);
        this.c = aSN1OctetString;
    }

    public ASN1Integer getSerialNumber() {
        return this.d;
    }

    public String printSerialNumber() {
        return PKIXUtils.arrayToString(this.d.toByteArray());
    }

    public void setSerialNumber(ASN1Integer aSN1Integer) {
        this.debug("serialNumber = " + aSN1Integer);
        PKIXUtils.verifyNotNull(aSN1Integer);
        this.d = aSN1Integer;
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.addElement((ASN1Value)this.c);
        aSN1Sequence.addElement((ASN1Value)this.d);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    public String toString() {
        return "CertID [hashAlg=" + this.a + ", issNameHash=" + this.b + ", issPKHash=" + this.c + ", serialNumber=" + this.d + "]";
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(AlgorithmIdentifier.TEMPLATE);
            this.seqt.addElement(ASN1OctetString.TEMPLATE);
            this.seqt.addElement(ASN1OctetString.TEMPLATE);
            this.seqt.addElement(ASN1Integer.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream object) throws IOException, InvalidBERException {
            aSN1Tag = this.getSequence(aSN1Tag, (InputStream)object);
            object = (AlgorithmIdentifier)aSN1Tag.elementAt(0);
            ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1Tag.elementAt(1);
            ASN1OctetString aSN1OctetString2 = (ASN1OctetString)aSN1Tag.elementAt(2);
            aSN1Tag = (ASN1Integer)aSN1Tag.elementAt(3);
            return new CertID((AlgorithmIdentifier)object, aSN1OctetString, aSN1OctetString2, (ASN1Integer)aSN1Tag);
        }
    }
}

