/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.cms;

import com.bifit.security.asn1.ASN1Choice;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.cms.OtherRevocationInfoFormat;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Choice;
import com.bifit.security.pkix.x509.CertificateList;
import com.bifit.security.util.Assert;
import java.io.IOException;
import java.io.InputStream;

public class RevocationInfoChoice
extends AbstractASN1Choice {
    private final Type a;
    public static final ASN1Template TEMPLATE = new a();

    RevocationInfoChoice(Type type, ASN1Value aSN1Value) {
        super(RevocationInfoChoice.class, aSN1Value);
        this.a = type;
    }

    public static RevocationInfoChoice getInstanceCertificateList(CertificateList certificateList) {
        return new RevocationInfoChoice(Type.CRL, (ASN1Value)certificateList);
    }

    public static RevocationInfoChoice getInstanceOther(OtherRevocationInfoFormat otherRevocationInfoFormat) {
        return new RevocationInfoChoice(Type.OTHER, (ASN1Value)otherRevocationInfoFormat);
    }

    public static RevocationInfoChoice getInstance(byte[] byArray) throws PKIXException {
        try {
            return (RevocationInfoChoice)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    public Type getType() {
        return this.a;
    }

    @Override
    public ASN1Tag getTag() {
        ASN1Tag aSN1Tag;
        if (this.a == Type.CRL) {
            aSN1Tag = CertificateList.TAG;
        } else {
            Assert.debugAssert((this.a == Type.OTHER ? 1 : 0) != 0);
            aSN1Tag = ASN1Tag.get((long)1L);
        }
        return aSN1Tag;
    }

    public CertificateList getCertificateList() {
        if (this.a == Type.CRL) {
            return (CertificateList)this.value;
        }
        return null;
    }

    public OtherRevocationInfoFormat getOther() {
        if (this.a == Type.OTHER) {
            return (OtherRevocationInfoFormat)this.value;
        }
        return null;
    }

    public boolean isCertificateList() {
        return this.a == Type.CRL;
    }

    public boolean isOther() {
        return this.a == Type.OTHER;
    }

    private static final class a
    extends AbstractASN1Choice.AbstractTemplateChoice {
        public a() {
            this.choicet.addElement(CertificateList.TEMPLATE);
            this.choicet.addElement(ASN1Tag.get((long)1L), OtherRevocationInfoFormat.TEMPLATE);
        }

        public final ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            inputStream = (ASN1Choice)this.choicet.decode(inputStream);
            Type type = object = inputStream.getTag().getNum() == 1L ? Type.OTHER : Type.CRL;
            inputStream = inputStream.getValue();
            return new RevocationInfoChoice(type, (ASN1Value)inputStream);
        }
    }

    public static enum Type {
        CRL,
        OTHER;

    }
}

