/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.cms;

import com.bifit.security.asn1.ASN1Explicit;
import com.bifit.security.asn1.ASN1Integer;
import com.bifit.security.asn1.ASN1OctetString;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.cms.OriginatorIdentifierOrKey;
import com.bifit.security.pkix.cms.RecipientEncryptedKeys;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.AlgorithmIdentifier;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class KeyAgreeRecipientInfo
extends AbstractASN1Sequence {
    private ASN1Integer a;
    private OriginatorIdentifierOrKey b;
    private ASN1OctetString c;
    private AlgorithmIdentifier d;
    private RecipientEncryptedKeys e;
    public static final ASN1Template TEMPLATE = new a();

    public KeyAgreeRecipientInfo(ASN1Integer aSN1Integer, OriginatorIdentifierOrKey originatorIdentifierOrKey, AlgorithmIdentifier algorithmIdentifier, RecipientEncryptedKeys recipientEncryptedKeys) {
        super(KeyAgreeRecipientInfo.class);
        PKIXUtils.verifyNotNull(aSN1Integer, originatorIdentifierOrKey, algorithmIdentifier, recipientEncryptedKeys);
        this.a = aSN1Integer;
        this.b = originatorIdentifierOrKey;
        this.d = algorithmIdentifier;
        this.e = recipientEncryptedKeys;
    }

    public void setVersion(ASN1Integer aSN1Integer) {
        PKIXUtils.verifyNotNull(aSN1Integer);
        this.a = aSN1Integer;
    }

    public void setOriginator(OriginatorIdentifierOrKey originatorIdentifierOrKey) {
        PKIXUtils.verifyNotNull(originatorIdentifierOrKey);
        this.b = originatorIdentifierOrKey;
    }

    public void setUkm(ASN1OctetString aSN1OctetString) {
        this.c = aSN1OctetString;
    }

    public void setKeyEncryptionAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
        PKIXUtils.verifyNotNull(algorithmIdentifier);
        this.d = algorithmIdentifier;
    }

    public void setRecipientEncryptedKeys(RecipientEncryptedKeys recipientEncryptedKeys) {
        PKIXUtils.verifyNotNull(recipientEncryptedKeys);
        this.e = recipientEncryptedKeys;
    }

    public ASN1Integer getVersion() {
        return this.a;
    }

    public OriginatorIdentifierOrKey getOriginator() {
        return this.b;
    }

    public ASN1OctetString getUkm() {
        return this.c;
    }

    public AlgorithmIdentifier getKeyEncryptionAlgorithm() {
        return this.d;
    }

    public RecipientEncryptedKeys getRecipientEncryptedKeys() {
        return this.e;
    }

    public static KeyAgreeRecipientInfo getInstance(byte[] byArray) throws PKIXException {
        try {
            return (KeyAgreeRecipientInfo)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)new ASN1Explicit(ASN1Tag.get((long)0L), (ASN1Value)this.b));
        aSN1Sequence.addOptionalExplicitElement(ASN1Tag.get((long)1L), (ASN1Value)this.c);
        aSN1Sequence.addElement((ASN1Value)this.d);
        aSN1Sequence.addElement((ASN1Value)this.e);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(ASN1Integer.TEMPLATE);
            this.seqt.addElement((ASN1Template)new ASN1Explicit.Template(ASN1Tag.get((long)0L), OriginatorIdentifierOrKey.TEMPLATE));
            this.seqt.addOptionalElement((ASN1Template)new ASN1Explicit.Template(ASN1Tag.get((long)1L), ASN1OctetString.TEMPLATE));
            this.seqt.addElement(AlgorithmIdentifier.TEMPLATE);
            this.seqt.addElement(RecipientEncryptedKeys.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag object, InputStream inputStream) throws InvalidBERException, IOException {
            try {
                object = this.getSequence((ASN1Tag)object, inputStream);
                inputStream = (ASN1Explicit)object.elementAt(1);
                OriginatorIdentifierOrKey originatorIdentifierOrKey = (OriginatorIdentifierOrKey)inputStream.getContent();
                inputStream = (ASN1Explicit)object.elementAt(2);
                inputStream = inputStream == null ? null : (ASN1OctetString)inputStream.getContent();
                object = new KeyAgreeRecipientInfo((ASN1Integer)object.elementAt(0), originatorIdentifierOrKey, (AlgorithmIdentifier)object.elementAt(3), (RecipientEncryptedKeys)object.elementAt(4));
                object.setUkm((ASN1OctetString)inputStream);
                return object;
            }
            catch (InvalidBERException invalidBERException) {
                object = invalidBERException;
                invalidBERException.append("KeyAgreeRecipientInfo()");
                throw object;
            }
        }
    }
}

