/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.cms;

import com.bifit.security.asn1.ASN1OctetString;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.crypto.DigestAdapter;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.AlgorithmIdentifier;
import com.bifit.security.pkix.x509.Certificate;
import com.bifit.security.pkix.x509.GeneralName;
import com.bifit.security.pkix.x509.GeneralNameType;
import com.bifit.security.pkix.x509.GeneralNames;
import com.bifit.security.pkix.x509.IssuerSerial;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ESSCertIDv2
extends AbstractASN1Sequence {
    private AlgorithmIdentifier a;
    private ASN1OctetString b;
    private IssuerSerial c;
    public static final ASN1Template TEMPLATE = new a();

    public ESSCertIDv2(AlgorithmIdentifier algorithmIdentifier, ASN1OctetString aSN1OctetString, IssuerSerial issuerSerial) {
        super(ESSCertIDv2.class);
        PKIXUtils.verifyNotNull(algorithmIdentifier, aSN1OctetString, issuerSerial);
        this.a = algorithmIdentifier;
        this.b = aSN1OctetString;
        this.c = issuerSerial;
    }

    public ESSCertIDv2(DigestAdapter digestAdapter, Certificate object) throws PKIXException {
        super(ESSCertIDv2.class);
        PKIXUtils.verifyNotNull(digestAdapter, object);
        byte[] byArray = digestAdapter.digest(object.encode());
        GeneralNames generalNames = new GeneralNames(new GeneralName(GeneralNameType.DIRECTORY_NAME, (ASN1Value)object.getInfo().getIssuer()));
        object = new IssuerSerial(generalNames, object.getInfo().getSerialNumber(), null);
        this.a = digestAdapter.getDigestAlgorithm();
        this.b = new ASN1OctetString(byArray);
        this.c = object;
    }

    public void setHashAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
        PKIXUtils.verifyNotNull(algorithmIdentifier);
        this.a = algorithmIdentifier;
    }

    public void setCertHash(ASN1OctetString aSN1OctetString) {
        PKIXUtils.verifyNotNull(aSN1OctetString);
        this.b = aSN1OctetString;
    }

    public void setIssuerSerial(IssuerSerial issuerSerial) {
        PKIXUtils.verifyNotNull(issuerSerial);
        this.c = issuerSerial;
    }

    public AlgorithmIdentifier getHashAlgorithm() {
        return this.a;
    }

    public ASN1OctetString getCertHash() {
        return this.b;
    }

    public IssuerSerial getIssuerSerial() {
        return this.c;
    }

    public static ESSCertIDv2 getInstance(byte[] byArray) throws PKIXException {
        try {
            return (ESSCertIDv2)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.addElement((ASN1Value)this.c);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(AlgorithmIdentifier.TEMPLATE);
            this.seqt.addElement(ASN1OctetString.TEMPLATE);
            this.seqt.addElement(IssuerSerial.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            aSN1Tag = this.getSequence(aSN1Tag, inputStream);
            return new ESSCertIDv2((AlgorithmIdentifier)aSN1Tag.elementAt(0), (ASN1OctetString)aSN1Tag.elementAt(1), (IssuerSerial)aSN1Tag.elementAt(2));
        }
    }
}

