/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.cms;

import com.bifit.security.asn1.ASN1Any;
import com.bifit.security.asn1.ASN1Explicit;
import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.asn1.ASN1OctetString;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.cms.DigestedData;
import com.bifit.security.pkix.cms.EncryptedData;
import com.bifit.security.pkix.cms.EnvelopedData;
import com.bifit.security.pkix.cms.SignedData;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.util.Assert;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ContentInfo
extends AbstractASN1Sequence {
    public static final ASN1ObjectIdentifier DATA = new ASN1ObjectIdentifier(new long[]{1L, 2L, 840L, 113549L, 1L, 7L, 1L});
    public static final ASN1ObjectIdentifier SIGNED_DATA = new ASN1ObjectIdentifier(new long[]{1L, 2L, 840L, 113549L, 1L, 7L, 2L});
    public static final ASN1ObjectIdentifier ENVELOPED_DATA = new ASN1ObjectIdentifier(new long[]{1L, 2L, 840L, 113549L, 1L, 7L, 3L});
    public static final ASN1ObjectIdentifier DIGESTED_DATA = new ASN1ObjectIdentifier(new long[]{1L, 2L, 840L, 113549L, 1L, 7L, 5L});
    public static final ASN1ObjectIdentifier ENCRYPTED_DATA = new ASN1ObjectIdentifier(new long[]{1L, 2L, 840L, 113549L, 1L, 7L, 6L});
    private final ASN1ObjectIdentifier a;
    private ASN1Any b;
    public static final ASN1Template TEMPLATE = new a();

    public ContentInfo(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Value aSN1Value) {
        super(ContentInfo.class);
        this.a = aSN1ObjectIdentifier;
        if (aSN1Value != null) {
            if (aSN1Value instanceof ASN1Any) {
                this.b = (ASN1Any)aSN1Value;
                return;
            }
            try {
                this.b = ASN1Any.getInstance((byte[])ASN1Util.encode((ASN1Value)aSN1Value));
                return;
            }
            catch (InvalidBERException invalidBERException) {
                Assert.notReached((String)"InvalidBERException while converting ASN1Value to ASN1Any");
            }
        }
    }

    public ContentInfo(byte[] byArray) {
        this(DATA, (ASN1Value)new ASN1OctetString(byArray));
    }

    public ContentInfo(SignedData signedData) {
        this(SIGNED_DATA, signedData);
    }

    public ContentInfo(EnvelopedData envelopedData) {
        this(ENVELOPED_DATA, envelopedData);
    }

    public ContentInfo(DigestedData digestedData) {
        this(DIGESTED_DATA, digestedData);
    }

    public ContentInfo(EncryptedData encryptedData) {
        this(ENCRYPTED_DATA, encryptedData);
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.a;
    }

    public boolean hasContent() {
        return this.b != null;
    }

    public ASN1Value getInterpretedContent() throws PKIXException {
        Object object;
        try {
            object = this.a.equals((Object)DATA) ? this.b.decodeWith(ASN1OctetString.TEMPLATE) : (this.a.equals((Object)SIGNED_DATA) ? this.b.decodeWith(SignedData.TEMPLATE) : (this.a.equals((Object)ENVELOPED_DATA) ? this.b.decodeWith(EnvelopedData.TEMPLATE) : (this.a.equals((Object)DIGESTED_DATA) ? this.b.decodeWith(DigestedData.TEMPLATE) : (this.a.equals((Object)ENCRYPTED_DATA) ? this.b.decodeWith(EncryptedData.TEMPLATE) : this.b))));
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(invalidBERException);
        }
        return object;
    }

    public SignedData getSignedData() throws PKIXException {
        if (this.a.equals((Object)SIGNED_DATA)) {
            try {
                return (SignedData)this.b.decodeWith(SignedData.TEMPLATE);
            }
            catch (InvalidBERException invalidBERException) {
                throw new PKIXException(invalidBERException);
            }
        }
        throw new PKIXException("It is not a SIGNED_DATA");
    }

    public EnvelopedData getEnvelopedData() throws PKIXException {
        if (this.a.equals((Object)ENVELOPED_DATA)) {
            try {
                return (EnvelopedData)this.b.decodeWith(EnvelopedData.TEMPLATE);
            }
            catch (InvalidBERException invalidBERException) {
                throw new PKIXException(invalidBERException);
            }
        }
        throw new PKIXException("It is not a SIGNED_DATA");
    }

    public ASN1Any getContent() {
        return this.b;
    }

    public static ContentInfo getInstance(byte[] byArray) throws PKIXException {
        try {
            return (ContentInfo)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addOptionalExplicitElement(ASN1Tag.get((long)0L), (ASN1Value)this.b);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement((ASN1Template)new ASN1ObjectIdentifier.Template());
            this.seqt.addOptionalElement((ASN1Template)new ASN1Explicit.Template(ASN1Tag.get((long)0L), (ASN1Template)new ASN1Any.Template()));
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            inputStream = (aSN1Tag = this.getSequence(aSN1Tag, inputStream)).elementAt(1) == null ? null : ((ASN1Explicit)aSN1Tag.elementAt(1)).getContent();
            return new ContentInfo((ASN1ObjectIdentifier)aSN1Tag.elementAt(0), (ASN1Value)inputStream);
        }
    }
}

