/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.cms;

import com.bifit.security.asn1.ASN1Choice;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.cms.OtherCertificateFormat;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Choice;
import com.bifit.security.pkix.x509.AttributeCertificate;
import com.bifit.security.pkix.x509.Certificate;
import com.bifit.security.util.Assert;
import java.io.IOException;
import java.io.InputStream;

public class CertificateChoices
extends AbstractASN1Choice {
    private final Type a;
    public static final ASN1Template TEMPLATE = new a();

    public Type getType() {
        return this.a;
    }

    CertificateChoices(Type type, ASN1Value aSN1Value) {
        super(CertificateChoices.class, aSN1Value);
        this.a = type;
    }

    public static CertificateChoices getInstanceCertificate(Certificate certificate) {
        return new CertificateChoices(Type.CERTIFICATE, (ASN1Value)certificate);
    }

    public static CertificateChoices getInstanceV2AttrCert(AttributeCertificate attributeCertificate) {
        return new CertificateChoices(Type.V2ATTR_CERT, (ASN1Value)attributeCertificate);
    }

    public static CertificateChoices getInstanceUnknownInfo(OtherCertificateFormat otherCertificateFormat) {
        return new CertificateChoices(Type.OTHER, (ASN1Value)otherCertificateFormat);
    }

    public static CertificateChoices getInstance(byte[] byArray) throws PKIXException {
        try {
            return (CertificateChoices)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    @Override
    public ASN1Tag getTag() {
        ASN1Tag aSN1Tag;
        switch (this.a) {
            case CERTIFICATE: {
                aSN1Tag = Certificate.TAG;
                break;
            }
            case V2ATTR_CERT: {
                aSN1Tag = ASN1Tag.get((long)2L);
                break;
            }
            default: {
                Assert.debugAssert((this.a == Type.OTHER ? 1 : 0) != 0);
                aSN1Tag = ASN1Tag.get((long)3L);
            }
        }
        return aSN1Tag;
    }

    public Certificate getCertificate() {
        if (this.a == Type.CERTIFICATE) {
            return (Certificate)this.value;
        }
        return null;
    }

    public AttributeCertificate getV2AttrCert() {
        if (this.a == Type.V2ATTR_CERT) {
            return (AttributeCertificate)this.value;
        }
        return null;
    }

    public OtherCertificateFormat getOther() {
        if (this.a == Type.OTHER) {
            return (OtherCertificateFormat)this.value;
        }
        return null;
    }

    public boolean isCertificate() {
        return this.a == Type.CERTIFICATE;
    }

    public boolean isV2AttrCert() {
        return this.a == Type.V2ATTR_CERT;
    }

    public boolean isOther() {
        return this.a == Type.OTHER;
    }

    static /* synthetic */ Type a(ASN1Tag object) {
        switch ((int)object.getNum()) {
            case 2: {
                object = Type.V2ATTR_CERT;
                break;
            }
            case 3: {
                object = Type.OTHER;
                break;
            }
            default: {
                object = Type.CERTIFICATE;
            }
        }
        return object;
    }

    private static final class a
    extends AbstractASN1Choice.AbstractTemplateChoice {
        public a() {
            this.choicet.addElement(Certificate.TEMPLATE);
            this.choicet.addElement(ASN1Tag.get((long)2L), AttributeCertificate.TEMPLATE);
            this.choicet.addElement(ASN1Tag.get((long)3L), OtherCertificateFormat.TEMPLATE);
        }

        public final ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            inputStream = (ASN1Choice)this.choicet.decode(inputStream);
            Type type = CertificateChoices.a(inputStream.getTag());
            inputStream = inputStream.getValue();
            return new CertificateChoices(type, (ASN1Value)inputStream);
        }
    }

    public static enum Type {
        CERTIFICATE,
        V2ATTR_CERT,
        OTHER;

    }
}

