/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.cms;

import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.asn1.ASN1OctetString;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.pkix.cms.ContentInfo;
import com.bifit.security.pkix.cms.OidCms;
import com.bifit.security.pkix.cms.SigningCertificateV2;
import com.bifit.security.pkix.esf.CompleteRevocationRefs;
import com.bifit.security.pkix.esf.RevocationValues;
import com.bifit.security.pkix.esf.SignaturePolicyIdentifier;
import com.bifit.security.pkix.ess.CompleteCertificateRefs;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.Attribute;
import com.bifit.security.pkix.primitive.Time;
import com.bifit.security.pkix.x509.Certificates;

public final class AttributeFactory {
    private AttributeFactory() {
    }

    public static Attribute createContentType(ASN1ObjectIdentifier aSN1ObjectIdentifier) throws PKIXException {
        return new Attribute(OidCms.CONTENT_TYPE, (ASN1Value)aSN1ObjectIdentifier);
    }

    public static Attribute createEssSigningCertificateV2(SigningCertificateV2 signingCertificateV2) throws PKIXException {
        return new Attribute(OidCms.AA_SIGNING_CERTIFICATE_V2, signingCertificateV2);
    }

    public static Attribute createMessageDigest(ASN1OctetString aSN1OctetString) throws PKIXException {
        return new Attribute(OidCms.MESSAGE_DIGEST, (ASN1Value)aSN1OctetString);
    }

    public static Attribute createSignaturePolicyIdentifier(SignaturePolicyIdentifier signaturePolicyIdentifier) throws PKIXException {
        return new Attribute(OidCms.AA_ETS_SIG_POLICY_ID, signaturePolicyIdentifier);
    }

    public static Attribute createSigningTime(Time time) throws PKIXException {
        return new Attribute(OidCms.SIGNING_TIME, time);
    }

    public static Attribute createContentTimeStamp(ContentInfo contentInfo) throws PKIXException {
        return new Attribute(OidCms.AA_ETS_CONTENT_TIME_STAMP, contentInfo);
    }

    public static Attribute createSignatureTimeStamp(ContentInfo contentInfo) throws PKIXException {
        return new Attribute(OidCms.AA_SIGNATURE_TIME_STAMP_TOKEN, contentInfo);
    }

    public static Attribute createCompleteCertificateReferences(CompleteCertificateRefs completeCertificateRefs) throws PKIXException {
        return new Attribute(OidCms.AA_ETS_CERTIFICATE_REFS, completeCertificateRefs);
    }

    public static Attribute createCompleteRevocationReferences(CompleteRevocationRefs completeRevocationRefs) throws PKIXException {
        return new Attribute(OidCms.AA_ETS_REVOCATION_REFS, completeRevocationRefs);
    }

    public static Attribute createCertificateValues(Certificates certificates) throws PKIXException {
        return new Attribute(OidCms.AA_ETS_CERT_VALUES, certificates);
    }

    public static Attribute createRevocationValues(RevocationValues revocationValues) throws PKIXException {
        return new Attribute(OidCms.AA_ETS_REVOCATION_VALUES, revocationValues);
    }
}

