/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.asn1;

import com.bifit.security.asn1.InvalidBERException;

public class ASN1Tag {
    private final long num;
    private final Class tClass;
    public static final Class UNIVERSAL = Class.UNIVERSAL;
    public static final Class APPLICATION = Class.APPLICATION;
    public static final Class CONTEXT_SPECIFIC = Class.CONTEXT_SPECIFIC;
    public static final Class PRIVATE = Class.PRIVATE;
    public static final ASN1Tag END_OF_CONTENTS;
    public static final ASN1Tag EOC;
    private static final int NUM_TAG_INSTANCES = 10;
    private static final ASN1Tag[] TAG_INSTANCES;

    public ASN1Tag(Class clazz, long l) {
        this.tClass = clazz;
        this.num = l;
    }

    public ASN1Tag(long l) {
        this(Class.CONTEXT_SPECIFIC, l);
    }

    public static ASN1Tag get(long l) {
        ASN1Tag aSN1Tag = l >= 0L && l < 10L ? TAG_INSTANCES[(int)l] : new ASN1Tag(l);
        return aSN1Tag;
    }

    public Class getTagClass() {
        return this.tClass;
    }

    public long getNum() {
        return this.num;
    }

    public int hashCode() {
        return this.tClass.toInt() * 131 + (int)this.num;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ASN1Tag)) {
            return false;
        }
        ASN1Tag aSN1Tag = (ASN1Tag)object;
        return this.num == aSN1Tag.num && this.tClass == aSN1Tag.tClass;
    }

    public String toString() {
        return this.tClass + " " + this.num;
    }

    static {
        EOC = END_OF_CONTENTS = new ASN1Tag(UNIVERSAL, 0L);
        TAG_INSTANCES = new ASN1Tag[10];
        for (int i = 0; i < 10; ++i) {
            ASN1Tag.TAG_INSTANCES[i] = new ASN1Tag(i);
        }
    }

    public static final class Class {
        private int encoding;
        private String name;
        public static final Class UNIVERSAL = new Class(0, "UNIVERSAL");
        public static final Class APPLICATION = new Class(1, "APPLICATION");
        public static final Class CONTEXT_SPECIFIC = new Class(2, "CONTEXT-SPECIFIC");
        public static final Class PRIVATE = new Class(3, "PRIVATE");

        private Class() {
        }

        private Class(int n, String string) {
            this.encoding = n;
            this.name = string;
        }

        public int toInt() {
            return this.encoding;
        }

        public String toString() {
            return this.name;
        }

        public static Class fromInt(int n) throws InvalidBERException {
            Class clazz;
            switch (n) {
                case 0: {
                    clazz = UNIVERSAL;
                    break;
                }
                case 1: {
                    clazz = APPLICATION;
                    break;
                }
                case 2: {
                    clazz = CONTEXT_SPECIFIC;
                    break;
                }
                case 3: {
                    clazz = PRIVATE;
                    break;
                }
                default: {
                    throw new InvalidBERException("Invalid tag class: " + n);
                }
            }
            return clazz;
        }
    }
}

