/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.asn1;

import com.bifit.security.asn1.ASN1Explicit;
import com.bifit.security.asn1.ASN1Form;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.AbstractASN1Value;
import com.bifit.security.asn1.CountingStream;
import com.bifit.security.asn1.Header;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.util.Assert;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class ASN1Set
extends AbstractASN1Value {
    public static final ASN1Tag TAG = new ASN1Tag(ASN1Tag.Class.UNIVERSAL, 17L);
    protected static final ASN1Form FORM = ASN1Form.CONSTRUCTED;
    protected List<Element> elements = new ArrayList<Element>();

    @Override
    public ASN1Tag getTag() {
        return TAG;
    }

    public static Template getSetTemplate() {
        return new Template();
    }

    public static OF_Template getSetTemplate(ASN1Template aSN1Template) {
        return new OF_Template(aSN1Template);
    }

    private void addElement(Element element) {
        this.elements.add(element);
    }

    private void insertElementAt(Element element, int n) {
        this.elements.add(n, element);
    }

    public boolean checkElementsType(Class<?> clazz) {
        for (int i = 0; i < this.elements.size(); ++i) {
            if (clazz.isInstance(this.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    public void addElement(ASN1Value aSN1Value) {
        this.addElement(new Element(aSN1Value));
    }

    public void addOptionalElement(ASN1Value aSN1Value) {
        if (aSN1Value != null) {
            this.addElement(aSN1Value);
        }
    }

    public void addElement(ASN1Tag aSN1Tag, ASN1Value aSN1Value) {
        this.addElement(new Element(aSN1Tag, aSN1Value));
    }

    public void addOptionalElement(ASN1Tag aSN1Tag, ASN1Value aSN1Value) {
        if (aSN1Value != null) {
            this.addElement(aSN1Tag, aSN1Value);
        }
    }

    public void addOptionalExplicitElement(ASN1Tag aSN1Tag, ASN1Value aSN1Value) {
        if (aSN1Value != null) {
            this.addElement(new ASN1Explicit(aSN1Tag, aSN1Value));
        }
    }

    public void insertElementAt(ASN1Value aSN1Value, int n) {
        this.insertElementAt(new Element(aSN1Value), n);
    }

    public void insertElementAt(ASN1Tag aSN1Tag, ASN1Value aSN1Value, int n) {
        this.insertElementAt(new Element(aSN1Tag, aSN1Value), n);
    }

    public ASN1Value elementAt(int n) {
        return this.elements.get(n).getValue();
    }

    public ASN1Tag tagAt(int n) {
        ASN1Tag aSN1Tag = this.elements.get(n).getImplicitTag();
        if (aSN1Tag == null) {
            return this.elementAt(n).getTag();
        }
        return aSN1Tag;
    }

    public ASN1Value elementWithTag(ASN1Tag aSN1Tag) {
        int n = this.elements.size();
        for (int i = 0; i < n; ++i) {
            Element element = this.elements.get(i);
            if (!element.getTag().equals(aSN1Tag)) continue;
            return element.getValue();
        }
        return null;
    }

    public int size() {
        return this.elements.size();
    }

    public void removeAllElements() {
        this.elements.clear();
    }

    public void removeElementAt(int n) {
        this.elements.remove(n);
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        Object object;
        int n;
        boolean bl = this.elements.size() < 2 ? true : this.tagAt(0).equals(this.tagAt(1));
        int n2 = this.elements.size();
        int n3 = 0;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(n2);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(n2);
        for (n = 0; n < n2; ++n) {
            if (this.elementAt(n) == null) continue;
            object = ASN1Util.encode(this.tagAt(n), this.elementAt(n));
            n3 += ((Object)object).length;
            if (bl) {
                ASN1Set.insertInOrder(arrayList, (byte[])object);
                continue;
            }
            ASN1Set.insertInOrder(arrayList, (byte[])object, arrayList2, (int)this.tagAt(n).getNum());
        }
        object = new Header(aSN1Tag, FORM, n3);
        ((Header)object).encode(outputStream);
        for (n = 0; n < arrayList.size(); ++n) {
            outputStream.write((byte[])arrayList.get(n));
        }
    }

    public static ASN1Set getInstance(ASN1Template aSN1Template, byte[] byArray) throws InvalidBERException {
        return (ASN1Set)ASN1Util.decode(aSN1Template, byArray);
    }

    public void berEncode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = this.elements.size();
        for (int i = 0; i < n; ++i) {
            object = this.elementAt(i);
            if (object == null) continue;
            object.encode(this.tagAt(i), byteArrayOutputStream);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        object = new Header(aSN1Tag, FORM, byArray.length);
        ((Header)object).encode(outputStream);
        outputStream.write(byArray);
    }

    private static void insertInOrder(List<byte[]> list, byte[] byArray) {
        int n;
        int n2 = list.size();
        for (n = 0; n < n2 && ASN1Set.compare(byArray, list.get(n)) >= 1; ++n) {
        }
        list.add(n, byArray);
    }

    private static void insertInOrder(List<byte[]> list, byte[] byArray, List<Integer> list2, int n) {
        int n2;
        int n3 = list.size();
        for (n2 = 0; n2 < n3 && n > list2.get(n2); ++n2) {
        }
        list.add(n2, byArray);
        list2.add(n2, n2);
    }

    private static int compare(byte[] byArray, byte[] byArray2) {
        int n = byArray.length < byArray2.length ? byArray.length : byArray2.length;
        for (int i = 0; i < n; ++i) {
            if ((byArray[i] & 0xFF) < (byArray2[i] & 0xFF)) {
                return -1;
            }
            if ((byArray[i] & 0xFF) <= (byArray2[i] & 0xFF)) continue;
            return 1;
        }
        if (byArray.length > n) {
            Assert.debugAssert(byArray2.length == n);
            return 1;
        }
        if (byArray2.length > n) {
            Assert.debugAssert(byArray.length == n);
            return -1;
        }
        return 0;
    }

    public static class OF_Template
    implements ASN1Template {
        private final Template template = new Template();

        public OF_Template(ASN1Template aSN1Template) {
            Template.Element element = new Template.Element(null, aSN1Template, false);
            element.makeRepeatable();
            this.template.addElement(element);
        }

        @Override
        public boolean tagMatch(ASN1Tag aSN1Tag) {
            return TAG.equals(aSN1Tag);
        }

        @Override
        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.template.decode(inputStream);
        }

        @Override
        public ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            return this.template.decode(aSN1Tag, inputStream);
        }
    }

    public static class Template
    implements ASN1Template {
        private final List<Element> elements = new ArrayList<Element>();

        private void addElement(Element element) {
            this.elements.add(element);
        }

        private void insertElementAt(Element element, int n) {
            this.elements.add(n, element);
        }

        public void addElement(ASN1Template aSN1Template) {
            this.addElement(new Element(null, aSN1Template, false));
        }

        public void insertElementAt(ASN1Template aSN1Template, int n) {
            this.insertElementAt(new Element(null, aSN1Template, false), n);
        }

        public void addElement(ASN1Tag aSN1Tag, ASN1Template aSN1Template) {
            this.addElement(new Element(aSN1Tag, aSN1Template, false));
        }

        public void insertElementAt(ASN1Tag aSN1Tag, ASN1Template aSN1Template, int n) {
            this.insertElementAt(new Element(aSN1Tag, aSN1Template, false), n);
        }

        public void addOptionalElement(ASN1Template aSN1Template) {
            this.addElement(new Element(null, aSN1Template, true));
        }

        public void insertOptionalElementAt(ASN1Template aSN1Template, int n) {
            this.insertElementAt(new Element(null, aSN1Template, true), n);
        }

        public void addOptionalElement(ASN1Tag aSN1Tag, ASN1Template aSN1Template) {
            this.addElement(new Element(aSN1Tag, aSN1Template, true));
        }

        public void insertOptionalElementAt(ASN1Tag aSN1Tag, ASN1Template aSN1Template, int n) {
            this.insertElementAt(new Element(aSN1Tag, aSN1Template, true), n);
        }

        public void addElement(ASN1Template aSN1Template, ASN1Value aSN1Value) {
            this.addElement(new Element(null, aSN1Template, aSN1Value));
        }

        public void insertElementAt(ASN1Template aSN1Template, ASN1Value aSN1Value, int n) {
            this.insertElementAt(new Element(null, aSN1Template, aSN1Value), n);
        }

        public void addElement(ASN1Tag aSN1Tag, ASN1Template aSN1Template, ASN1Value aSN1Value) {
            this.addElement(new Element(aSN1Tag, aSN1Template, aSN1Value));
        }

        public void insertElementAt(ASN1Tag aSN1Tag, ASN1Template aSN1Template, ASN1Value aSN1Value, int n) {
            this.insertElementAt(new Element(aSN1Tag, aSN1Template, aSN1Value), n);
        }

        public ASN1Tag implicitTagAt(int n) {
            return this.elements.get(n).getImplicitTag();
        }

        public ASN1Template templateAt(int n) {
            return this.elements.get(n).getTemplate();
        }

        public boolean isOptionalAt(int n) {
            return this.elements.get(n).isOptional();
        }

        private boolean isRepeatableAt(int n) {
            return this.elements.get(n).isRepeatable();
        }

        public ASN1Value defaultAt(int n) {
            return this.elements.get(n).getDefault();
        }

        public int size() {
            return this.elements.size();
        }

        public void removeAllElements() {
            this.elements.clear();
        }

        public void removeElementAt(int n) {
            this.elements.remove(n);
        }

        private ASN1Tag getTag() {
            return TAG;
        }

        @Override
        public boolean tagMatch(ASN1Tag aSN1Tag) {
            return aSN1Tag.equals(TAG);
        }

        @Override
        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(this.getTag(), inputStream);
        }

        @Override
        public ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            try {
                int n;
                Header header = new Header(inputStream);
                header.validate(aSN1Tag, ASN1Form.CONSTRUCTED);
                long l = header.getContentLength();
                ASN1Set aSN1Set = new ASN1Set();
                boolean[] blArray = new boolean[this.elements.size()];
                while (l > 0L || l == -1L) {
                    Header header2 = Header.lookAhead(inputStream);
                    if (header2.isEOC()) {
                        if (l != -1L) {
                            throw new InvalidBERException("Unexpected end-of-contentmarker");
                        }
                        header2 = new Header(inputStream);
                        break;
                    }
                    n = this.findElementByTag(header2.getTag());
                    if (n == -1) {
                        throw new InvalidBERException("Unexpected Tag in ASN1Set: " + header2.getTag());
                    }
                    Element element = this.elements.get(n);
                    if (blArray[n] && !element.isRepeatable()) {
                        throw new InvalidBERException("Duplicate Tag in ASN1Set: " + header2.getTag());
                    }
                    blArray[n] = true;
                    ASN1Template aSN1Template = element.getTemplate();
                    CountingStream countingStream = new CountingStream(inputStream);
                    ASN1Value aSN1Value = element.getImplicitTag() == null ? aSN1Template.decode(countingStream) : aSN1Template.decode(element.getImplicitTag(), countingStream);
                    long l2 = countingStream.getNumRead();
                    if (l != -1L) {
                        if (l < l2) {
                            throw new InvalidBERException("Item went " + (l2 - l) + " bytes past the end of" + " the ASN1Set");
                        }
                        l -= l2;
                    }
                    com.bifit.security.asn1.ASN1Set$Element element2 = element.getImplicitTag() == null ? new com.bifit.security.asn1.ASN1Set$Element(aSN1Value) : new com.bifit.security.asn1.ASN1Set$Element(element.getImplicitTag(), aSN1Value);
                    aSN1Set.addElement(element2);
                }
                Assert.debugAssert(l == 0L || l == -1L);
                n = this.elements.size();
                for (int i = 0; i < n; ++i) {
                    if (blArray[i] || this.isOptionalAt(i) || this.isRepeatableAt(i)) continue;
                    if (this.defaultAt(i) == null) {
                        throw new InvalidBERException("Field not found in ASN1Set");
                    }
                    aSN1Set.addElement(new com.bifit.security.asn1.ASN1Set$Element(this.defaultAt(i)));
                }
                return aSN1Set;
            }
            catch (InvalidBERException invalidBERException) {
                throw new InvalidBERException(invalidBERException, "ASN1Set");
            }
        }

        private int findElementByTag(ASN1Tag aSN1Tag) {
            int n = this.elements.size();
            for (int i = 0; i < n; ++i) {
                Element element = this.elements.get(i);
                if (!element.tagMatch(aSN1Tag)) continue;
                return i;
            }
            return -1;
        }

        public static class Element {
            private ASN1Value defaultVal;
            private final boolean optional;
            private final ASN1Tag implicitTag;
            private final ASN1Template type;
            private boolean repeatable;

            public Element(ASN1Tag aSN1Tag, ASN1Template aSN1Template, boolean bl) {
                this.type = aSN1Template;
                this.optional = bl;
                this.implicitTag = aSN1Tag;
            }

            public Element(ASN1Tag aSN1Tag, ASN1Template aSN1Template, ASN1Value aSN1Value) {
                this.type = aSN1Template;
                this.defaultVal = aSN1Value;
                this.optional = false;
                this.implicitTag = aSN1Tag;
            }

            private void makeRepeatable() {
                this.repeatable = true;
            }

            private boolean isRepeatable() {
                return this.repeatable;
            }

            public boolean isOptional() {
                return this.optional;
            }

            public ASN1Tag getImplicitTag() {
                return this.implicitTag;
            }

            public boolean tagMatch(ASN1Tag aSN1Tag) {
                if (this.implicitTag == null) {
                    return this.type.tagMatch(aSN1Tag);
                }
                return this.implicitTag.equals(aSN1Tag);
            }

            public ASN1Template getTemplate() {
                return this.type;
            }

            public ASN1Value getDefault() {
                return this.defaultVal;
            }
        }
    }

    static class Element {
        private ASN1Tag implicitTag;
        private final ASN1Value val;

        public Element(ASN1Value aSN1Value) {
            this.val = aSN1Value;
        }

        public Element(ASN1Tag aSN1Tag, ASN1Value aSN1Value) {
            this.val = aSN1Value;
            this.implicitTag = aSN1Tag;
        }

        public ASN1Value getValue() {
            return this.val;
        }

        public ASN1Tag getTag() {
            if (this.implicitTag == null) {
                return this.val.getTag();
            }
            return this.implicitTag;
        }

        public ASN1Tag getImplicitTag() {
            return this.implicitTag;
        }
    }
}

