/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.asn1;

import com.bifit.security.asn1.ASN1Form;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.AbstractASN1Value;
import com.bifit.security.asn1.Header;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.util.Assert;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ASN1ObjectIdentifier
extends AbstractASN1Value {
    private final long[] numbers;
    public static final ASN1ObjectIdentifier RSADSI = new ASN1ObjectIdentifier(new long[]{1L, 2L, 840L, 113549L});
    public static final ASN1ObjectIdentifier PKCS = RSADSI.subBranch(1L);
    public static final ASN1ObjectIdentifier PKCS1 = PKCS.subBranch(1L);
    public static final ASN1ObjectIdentifier PKCS2 = PKCS.subBranch(2L);
    public static final ASN1ObjectIdentifier RSA_DIGEST = RSADSI.subBranch(2L);
    public static final ASN1ObjectIdentifier PKCS5 = PKCS.subBranch(5L);
    public static final ASN1ObjectIdentifier PKCS9 = PKCS.subBranch(9L);
    public static final ASN1ObjectIdentifier PKCS12 = PKCS.subBranch(12L);
    public static final ASN1ObjectIdentifier RSA_CIPHER = RSADSI.subBranch(3L);
    public static final ASN1ObjectIdentifier ALGORITHM = new ASN1ObjectIdentifier(new long[]{1L, 3L, 14L, 3L, 2L});
    public static final ASN1ObjectIdentifier HASH_ALGORITHM = new ASN1ObjectIdentifier(new long[]{2L, 16L, 840L, 1L, 101L, 3L, 4L, 2L});
    public static final ASN1ObjectIdentifier PKIX = new ASN1ObjectIdentifier(new long[]{1L, 3L, 6L, 1L, 5L, 5L, 7L});
    public static final ASN1ObjectIdentifier ID_CMC = PKIX.subBranch(7L);
    public static final ASN1ObjectIdentifier ID_CMC_CMC_STATUS_INFO = ID_CMC.subBranch(1L);
    public static final ASN1ObjectIdentifier ID_CMC_IDENTIFICATION = ID_CMC.subBranch(2L);
    public static final ASN1ObjectIdentifier ID_CMC_INDENTITY_PROOF = ID_CMC.subBranch(3L);
    public static final ASN1ObjectIdentifier ID_CMC_DATA_RETURN = ID_CMC.subBranch(4L);
    public static final ASN1ObjectIdentifier ID_CMC_TRANSACTION_ID = ID_CMC.subBranch(5L);
    public static final ASN1ObjectIdentifier ID_CMC_SENDER_NONCE = ID_CMC.subBranch(6L);
    public static final ASN1ObjectIdentifier ID_CMC_RECIPIENT_NONCE = ID_CMC.subBranch(7L);
    public static final ASN1ObjectIdentifier ID_CMC_ADD_EXTENSIONS = ID_CMC.subBranch(8L);
    public static final ASN1ObjectIdentifier ID_CMC_DECRYPTED_POP = ID_CMC.subBranch(10L);
    public static final ASN1ObjectIdentifier ID_CMC_ENCRYPTED_POP = ID_CMC.subBranch(9L);
    public static final ASN1ObjectIdentifier ID_CMC_LRA_POP_WITNESS = ID_CMC.subBranch(11L);
    public static final ASN1ObjectIdentifier ID_CMC_GET_CERT = ID_CMC.subBranch(15L);
    public static final ASN1ObjectIdentifier ID_CMC_GET_CRL = ID_CMC.subBranch(16L);
    public static final ASN1ObjectIdentifier ID_CMC_REVOKE_REQUEST = ID_CMC.subBranch(17L);
    public static final ASN1ObjectIdentifier ID_CMC_REG_INFO = ID_CMC.subBranch(18L);
    public static final ASN1ObjectIdentifier ID_CMC_RESPONSE_INFO = ID_CMC.subBranch(19L);
    public static final ASN1ObjectIdentifier ID_CMC_QUERY_PENDING = ID_CMC.subBranch(21L);
    public static final ASN1ObjectIdentifier ID_CMC_ID_POP_LINK_RANDOM = ID_CMC.subBranch(22L);
    public static final ASN1ObjectIdentifier ID_CMC_ID_POP_LINK_WITNESS = ID_CMC.subBranch(23L);
    public static final ASN1ObjectIdentifier ID_CMC_ID_CONFIRM_CERT_ACCEPTANCE = ID_CMC.subBranch(24L);
    public static final ASN1ObjectIdentifier ID_CCT = PKIX.subBranch(12L);
    public static final ASN1ObjectIdentifier ID_CCT_PKI_DATA = ID_CCT.subBranch(2L);
    public static final ASN1ObjectIdentifier ID_CCT_PKI_RESPONSE = ID_CCT.subBranch(3L);
    public static final ASN1Tag TAG = new ASN1Tag(ASN1Tag.Class.UNIVERSAL, 6L);
    public static final ASN1Form FORM = ASN1Form.PRIMITIVE;
    public static final ASN1Template TEMPLATE = new Template();
    private byte[] encodedContents;
    private byte[] cachedEncoding;
    private ASN1Tag tagForCache;

    @Override
    public ASN1Tag getTag() {
        return TAG;
    }

    public ASN1ObjectIdentifier(long[] lArray) {
        ASN1ObjectIdentifier.checkLongArray(lArray);
        this.numbers = ASN1Util.copy(lArray);
    }

    private static void checkLongArray(long[] lArray) {
        Assert.debugAssert(lArray != null);
        Assert.debugAssert(lArray.length >= 2);
        Assert.debugAssert(lArray[0] == 0L || lArray[0] == 1L || lArray[0] == 2L);
    }

    public ASN1ObjectIdentifier(String string) throws NumberFormatException {
        if (string == null || string.length() == 0) {
            throw new NumberFormatException("OID string is zero-length");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        this.numbers = new long[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            this.numbers[n++] = Long.parseLong(stringTokenizer.nextToken());
        }
        Assert.debugAssert(n == this.numbers.length);
        ASN1ObjectIdentifier.checkLongArray(this.numbers);
    }

    public long[] getNumbers() {
        return ASN1Util.copy(this.numbers);
    }

    @Override
    public int hashCode() {
        int n = 1;
        for (long l : this.numbers) {
            n = (int)((long)n + l) * 10;
        }
        return n;
    }

    public boolean checkParentBranch(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        if (this.numbers.length < aSN1ObjectIdentifier.numbers.length) {
            return false;
        }
        for (int i = 0; i < aSN1ObjectIdentifier.numbers.length; ++i) {
            if (this.numbers[i] == aSN1ObjectIdentifier.numbers[i]) continue;
            return false;
        }
        return true;
    }

    public ASN1ObjectIdentifier subBranch(long l) {
        long[] lArray = new long[this.numbers.length + 1];
        System.arraycopy(this.numbers, 0, lArray, 0, this.numbers.length);
        lArray[this.numbers.length] = l;
        return new ASN1ObjectIdentifier(lArray);
    }

    public ASN1ObjectIdentifier subBranch(long[] lArray) {
        long[] lArray2 = new long[this.numbers.length + lArray.length];
        System.arraycopy(this.numbers, 0, lArray2, 0, this.numbers.length);
        System.arraycopy(lArray, 0, lArray2, this.numbers.length, lArray.length);
        return new ASN1ObjectIdentifier(lArray2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.numbers[0]);
        for (int i = 1; i < this.numbers.length; ++i) {
            stringBuilder.append('.');
            stringBuilder.append(this.numbers[i]);
        }
        return stringBuilder.toString();
    }

    private byte[] getEncodedContents() {
        if (this.encodedContents == null) {
            this.encodedContents = this.computeEncodedContents();
        }
        return this.encodedContents;
    }

    private byte[] getEncoding(ASN1Tag aSN1Tag) {
        if (!aSN1Tag.equals(this.tagForCache)) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Header header = this.getHeader(aSN1Tag);
            try {
                header.encode(byteArrayOutputStream);
            }
            catch (IOException iOException) {
                Assert.notReached("exception while encoding ASN.1 header");
            }
            byteArrayOutputStream.write(this.getEncodedContents(), 0, this.getEncodedContents().length);
            this.tagForCache = aSN1Tag;
            this.cachedEncoding = byteArrayOutputStream.toByteArray();
        }
        return this.cachedEncoding;
    }

    private Header getHeader(ASN1Tag aSN1Tag) {
        return new Header(aSN1Tag, FORM, this.getEncodedContents().length);
    }

    private byte[] computeEncodedContents() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Assert.debugAssert(this.numbers.length >= 2);
        long l = this.numbers[0];
        Assert.debugAssert(l == 0L || l == 1L || l == 2L);
        long l2 = this.numbers[0] * 40L + this.numbers[1];
        Assert.debugAssert((long)((byte)l2) == l2);
        byteArrayOutputStream.write((byte)l2);
        byte[] byArray = new byte[10];
        for (int i = 2; i < this.numbers.length; ++i) {
            l = this.numbers[i];
            Assert.debugAssert(l >= 0L);
            int n = 0;
            do {
                byArray[n++] = (byte)(l % 128L);
            } while ((l /= 128L) > 0L);
            --n;
            while (n > 0) {
                byteArrayOutputStream.write(byArray[n--] | 0x80);
            }
            Assert.debugAssert(n == 0);
            byteArrayOutputStream.write(byArray[0]);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static ASN1ObjectIdentifier getInstance(byte[] byArray) throws InvalidBERException {
        return (ASN1ObjectIdentifier)ASN1Util.decode(TEMPLATE, byArray);
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        outputStream.write(this.getEncoding(aSN1Tag));
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ASN1ObjectIdentifier)) {
            return false;
        }
        long[] lArray = ((ASN1ObjectIdentifier)object).numbers;
        if (lArray.length != this.numbers.length) {
            return false;
        }
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] == this.numbers[i]) continue;
            return false;
        }
        return true;
    }

    public static class Template
    implements ASN1Template {
        public ASN1Tag getTag() {
            return TAG;
        }

        @Override
        public boolean tagMatch(ASN1Tag aSN1Tag) {
            return aSN1Tag.equals(TAG);
        }

        public ASN1Form getForm() {
            return FORM;
        }

        public boolean formMatch(ASN1Form aSN1Form) {
            return aSN1Form == FORM;
        }

        @Override
        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(this.getTag(), inputStream);
        }

        @Override
        public ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            try {
                Header header = new Header(inputStream);
                if (!header.getTag().equals(aSN1Tag)) {
                    throw new InvalidBERException("Incorrect tag for OBJECT IDENTIFIER: " + header.getTag());
                }
                if (header.getForm() != this.getForm()) {
                    throw new InvalidBERException("Incorrect form for OBJECT IDENTIFIER");
                }
                long l = header.getContentLength();
                if (l < 1L) {
                    throw new InvalidBERException("Invalid 0 length for OBJECT IDENTIFIER");
                }
                ArrayList<Long> arrayList = new ArrayList<Long>();
                byte by = Template.readByte(inputStream);
                --l;
                long l2 = by % 40;
                arrayList.add(Long.valueOf(by % 40));
                arrayList.add(0, Long.valueOf(by / 40));
                while (l > 0L) {
                    l2 = 0L;
                    int n = 0;
                    do {
                        if ((n += 7) > 63) {
                            throw new InvalidBERException("OBJECT IDENTIFIER element too long; max is 63 bits");
                        }
                        by = Template.readByte(inputStream);
                        --l;
                        l2 <<= 7;
                        l2 |= (long)(by & 0x7F);
                    } while ((by & 0x80) != 0);
                    arrayList.add(l2);
                }
                long[] lArray = new long[arrayList.size()];
                for (int i = 0; i < lArray.length; ++i) {
                    lArray[i] = (Long)arrayList.get(i);
                }
                return new ASN1ObjectIdentifier(lArray);
            }
            catch (InvalidBERException invalidBERException) {
                throw new InvalidBERException(invalidBERException, "ASN1ObjectIdentifier");
            }
        }

        private static byte readByte(InputStream inputStream) throws InvalidBERException, IOException {
            int n = inputStream.read();
            if (n == -1) {
                throw new InvalidBERException("End-of-file reached while decoding OBJECT IDENTIFIER");
            }
            Assert.debugAssert((n & 0xFF) == n);
            return (byte)n;
        }
    }
}

