/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.asn1;

import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.AbstractASN1CharacterString;
import com.bifit.security.asn1.CharConverter;
import com.bifit.security.asn1.InvalidBERException;
import java.io.CharConversionException;

public class ASN1IA5String
extends AbstractASN1CharacterString {
    public static final ASN1Tag TAG = new ASN1Tag(ASN1Tag.Class.UNIVERSAL, 22L);
    public static final ASN1Template TEMPLATE = new Template();

    public ASN1IA5String(char[] cArray) throws CharConversionException {
        super(cArray);
    }

    public ASN1IA5String(String string) throws CharConversionException {
        super(string);
    }

    @Override
    protected CharConverter getCharConverter() {
        return new IA5Converter();
    }

    @Override
    public ASN1Tag getTag() {
        return TAG;
    }

    public static ASN1IA5String getInstance(byte[] byArray) throws InvalidBERException {
        return (ASN1IA5String)ASN1Util.decode(TEMPLATE, byArray);
    }

    private static class IA5Converter
    implements CharConverter {
        private IA5Converter() {
        }

        @Override
        public char[] byteToChar(byte[] byArray, int n, int n2) throws CharConversionException {
            char[] cArray = new char[n2];
            int n3 = n;
            for (int i = 0; i < n2; ++i) {
                if ((byArray[n3] & 0x80) != 0) {
                    throw new CharConversionException("Invalid character: " + byArray[n3]);
                }
                cArray[i] = (char)(byArray[n3] & 0x7F);
                ++n3;
            }
            return cArray;
        }

        @Override
        public byte[] charToByte(char[] cArray, int n, int n2) throws CharConversionException {
            byte[] byArray = new byte[n2];
            int n3 = n;
            for (int i = 0; i < n2; ++i) {
                if ((cArray[n3] & 0x7F) != cArray[n3]) {
                    throw new CharConversionException("Invalid character: " + cArray[n3]);
                }
                byArray[i] = (byte)(cArray[n3] & 0x7F);
                ++n3;
            }
            return byArray;
        }
    }

    public static class Template
    extends AbstractASN1CharacterString.AbstractTemplate
    implements ASN1Template {
        @Override
        public ASN1Tag getTag() {
            return TAG;
        }

        @Override
        public boolean tagMatch(ASN1Tag aSN1Tag) {
            return aSN1Tag.equals(TAG);
        }

        @Override
        protected CharConverter getCharConverter() {
            return new IA5Converter();
        }

        @Override
        protected AbstractASN1CharacterString generateInstance(char[] cArray) throws CharConversionException {
            return new ASN1IA5String(cArray);
        }

        @Override
        protected String typeName() {
            return "ASN1IA5String";
        }
    }
}

