/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.asn1;

import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.AbstractASN1Value;
import com.bifit.security.asn1.Header;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.util.Assert;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class ASN1Choice
extends AbstractASN1Value {
    private final ASN1Tag tag;
    private final ASN1Value val;

    public ASN1Choice(ASN1Tag aSN1Tag, ASN1Value aSN1Value) {
        this.tag = aSN1Tag;
        this.val = aSN1Value;
    }

    public ASN1Choice(ASN1Value aSN1Value) {
        this.tag = aSN1Value.getTag();
        this.val = aSN1Value;
    }

    @Override
    public ASN1Tag getTag() {
        return this.tag;
    }

    public ASN1Value getValue() {
        return this.val;
    }

    public static ASN1Choice getInstance(ASN1Template aSN1Template, byte[] byArray) throws InvalidBERException {
        return (ASN1Choice)ASN1Util.decode(aSN1Template, byArray);
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        this.val.encode(this.tag, outputStream);
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        Assert.debugAssert(aSN1Tag.equals(this.tag));
        this.val.encode(this.tag, outputStream);
    }

    public static Template getChoiceTemplate() {
        return new Template();
    }

    public static class Template
    implements ASN1Template {
        private final List<Element> templates = new ArrayList<Element>();

        public void addElement(ASN1Template aSN1Template) {
            this.templates.add(new Element(aSN1Template));
        }

        public void addElement(ASN1Tag aSN1Tag, ASN1Template aSN1Template) {
            this.templates.add(new Element(aSN1Tag, aSN1Template));
        }

        public int size() {
            return this.templates.size();
        }

        public ASN1Template elementAt(int n) {
            return this.templates.get(n).getTemplate();
        }

        public ASN1Tag implicitTagAt(int n) {
            return this.templates.get(n).getImplicitTag();
        }

        public void removeAllElements() {
            this.templates.clear();
        }

        public void removeElementAt(int n) {
            this.templates.remove(n);
        }

        @Override
        public boolean tagMatch(ASN1Tag aSN1Tag) {
            int n = this.size();
            for (int i = 0; i < n; ++i) {
                ASN1Template aSN1Template;
                ASN1Tag aSN1Tag2 = this.implicitTagAt(i);
                if (!(aSN1Tag2 == null ? (aSN1Template = this.elementAt(i)).tagMatch(aSN1Tag) : aSN1Tag2.equals(aSN1Tag))) continue;
                return true;
            }
            return false;
        }

        @Override
        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            Header header = Header.lookAhead(inputStream);
            ASN1Tag aSN1Tag = header.getTag();
            int n = this.size();
            for (int i = 0; i < n; ++i) {
                if (this.implicitTagAt(i) == null) {
                    if (!this.elementAt(i).tagMatch(aSN1Tag)) continue;
                    return new ASN1Choice(this.elementAt(i).decode(inputStream));
                }
                if (!this.implicitTagAt(i).equals(aSN1Tag)) continue;
                ASN1Value aSN1Value = this.elementAt(i).decode(this.implicitTagAt(i), inputStream);
                return new ASN1Choice(this.implicitTagAt(i), aSN1Value);
            }
            throw new InvalidBERException("Decoding error ASN1Choice");
        }

        @Override
        public ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(inputStream);
        }

        private static class Element {
            private final ASN1Template template;
            private ASN1Tag implicitTag;

            public Element(ASN1Template aSN1Template) {
                this.template = aSN1Template;
            }

            public Element(ASN1Tag aSN1Tag, ASN1Template aSN1Template) {
                this.template = aSN1Template;
                this.implicitTag = aSN1Tag;
            }

            public ASN1Template getTemplate() {
                return this.template;
            }

            public ASN1Tag getImplicitTag() {
                return this.implicitTag;
            }
        }
    }
}

