/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.asn1;

import com.bifit.security.asn1.ASN1Form;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.AbstractASN1Value;
import com.bifit.security.asn1.Header;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.util.Assert;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.BitSet;

public class ASN1BitString
extends AbstractASN1Value {
    private final byte[] bits;
    private final int padCount;
    private boolean removeTrailingZeroes;
    public static final ASN1Tag TAG = new ASN1Tag(ASN1Tag.UNIVERSAL, 3L);
    public static final ASN1Form FORM = ASN1Form.PRIMITIVE;
    public static final ASN1Template TEMPLATE = new Template();

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ASN1BitString)) {
            return false;
        }
        ASN1BitString aSN1BitString = (ASN1BitString)object;
        return this.padCount == aSN1BitString.padCount && this.removeTrailingZeroes == aSN1BitString.removeTrailingZeroes && Arrays.equals(this.bits, aSN1BitString.bits);
    }

    public ASN1BitString(byte[] byArray, int n) throws NumberFormatException {
        if (n < 0 || n > 7) {
            throw new NumberFormatException();
        }
        if (byArray.length == 0 && n != 0) {
            throw new NumberFormatException();
        }
        this.bits = ASN1Util.copy(byArray);
        this.padCount = n;
    }

    public ASN1BitString(BitSet bitSet, int n) throws NumberFormatException {
        if (n < 0 || n > bitSet.size()) {
            throw new NumberFormatException();
        }
        this.bits = new byte[(n + 7) / 8];
        this.padCount = this.bits.length * 8 - n;
        Assert.debugAssert(this.padCount >= 0 && this.padCount <= 7);
        for (int i = 0; i < n; ++i) {
            if (!bitSet.get(i)) continue;
            int n2 = i / 8;
            this.bits[n2] = (byte)(this.bits[n2] | 128 >>> i % 8);
        }
    }

    public boolean isRemoveTrailingZeroes() {
        return this.removeTrailingZeroes;
    }

    public void setRemoveTrailingZeroes(boolean bl) {
        this.removeTrailingZeroes = bl;
    }

    public byte[] getBits() {
        return ASN1Util.copy(this.bits);
    }

    public byte[] getBitsWithPadCount() {
        byte[] byArray = this.getBits();
        byte by = (byte)(255 >> this.padCount);
        for (int i = byArray.length - 1; i >= 0; --i) {
            if (i != byArray.length - 1) {
                byArray[i + 1] = (byte)(byArray[i + 1] | byArray[i] << 8 - this.padCount);
            }
            byArray[i] = (byte)(byArray[i] >> this.padCount & by);
        }
        return byArray;
    }

    public BitSet toBitSet() {
        BitSet bitSet = new BitSet();
        int n = this.bits.length * 8 - this.padCount;
        for (int i = 0; i < n; ++i) {
            if ((this.bits[i / 8] & 128 >>> i % 8) == 0) {
                bitSet.clear(i);
                continue;
            }
            bitSet.set(i);
        }
        return bitSet;
    }

    public boolean[] toBooleanArray() {
        boolean[] blArray = new boolean[this.bits.length * 8 - this.padCount];
        for (int i = 0; i < blArray.length; ++i) {
            if ((this.bits[i / 8] & 128 >>> i % 8) == 0) continue;
            blArray[i] = true;
        }
        return blArray;
    }

    public void setBit(int n, boolean bl) {
        byte by = (byte)(128 >>> n % 8);
        if (bl) {
            int n2 = n / 8;
            this.bits[n2] = (byte)(this.bits[n2] | by);
        } else {
            by = (byte)(by ^ 0xFF);
            int n3 = n / 8;
            this.bits[n3] = (byte)(this.bits[n3] & by);
        }
    }

    public boolean getBit(int n) {
        return (this.bits[n / 8] & 128 >>> n % 8) != 0;
    }

    public int getPadCount() {
        return this.padCount;
    }

    @Override
    public ASN1Tag getTag() {
        return TAG;
    }

    public static ASN1BitString getInstance(byte[] byArray) throws InvalidBERException {
        return (ASN1BitString)ASN1Util.decode(TEMPLATE, byArray);
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        int n;
        int n2;
        if (this.bits.length > 0) {
            int n3 = this.bits.length - 1;
            this.bits[n3] = (byte)(this.bits[n3] & 255 << this.padCount);
        }
        if (this.removeTrailingZeroes) {
            for (n2 = this.bits.length; n2 > 0 && this.bits[n2 - 1] == 0; --n2) {
            }
            if (n2 == 0) {
                n = 0;
            } else {
                for (n = 0; n < 8 && (this.bits[n2 - 1] & 1 << n) == 0; ++n) {
                }
                Assert.debugAssert(n >= 0 && n <= 7);
            }
        } else {
            n = this.padCount;
            n2 = this.bits.length;
        }
        Header header = new Header(aSN1Tag, FORM, n2 + 1);
        header.encode(outputStream);
        outputStream.write(n);
        outputStream.write(this.bits, 0, n2);
    }

    public static class Template
    implements ASN1Template {
        @Override
        public boolean tagMatch(ASN1Tag aSN1Tag) {
            return TAG.equals(aSN1Tag);
        }

        @Override
        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(TAG, inputStream);
        }

        @Override
        public ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            try {
                Header header = new Header(inputStream);
                header.validate(aSN1Tag);
                if (header.getContentLength() == -1L) {
                    Header header2;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    Template template = new Template();
                    int n = 0;
                    do {
                        if ((header2 = Header.lookAhead(inputStream)).isEOC()) continue;
                        if (n != 0) {
                            throw new InvalidBERException("Element of constructed BIT STRING has nonzero unused bits, but is not\nthe last element of the construction.");
                        }
                        ASN1BitString aSN1BitString = (ASN1BitString)template.decode(inputStream);
                        byteArrayOutputStream.write(aSN1BitString.getBits());
                        n = aSN1BitString.getPadCount();
                    } while (!header2.isEOC());
                    header2 = new Header(inputStream);
                    return new ASN1BitString(byteArrayOutputStream.toByteArray(), n);
                }
                int n = inputStream.read();
                if (n == -1) {
                    throw new InvalidBERException.EndOfFile();
                }
                if (n < 0 || n > 7) {
                    throw new InvalidBERException("Unused bits not in range [0,7]");
                }
                byte[] byArray = new byte[(int)header.getContentLength() - 1];
                ASN1Util.readFully(byArray, inputStream);
                return new ASN1BitString(byArray, n);
            }
            catch (InvalidBERException invalidBERException) {
                throw new InvalidBERException(invalidBERException, "ASN1BitString");
            }
        }
    }
}

