/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.core;

public final class Utils {
    public static int byte2int(byte[] byArray, int n2) {
        return byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16 | byArray[n2] << 24;
    }

    public static void int2byte(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)n2;
        byArray[n3 + 1] = (byte)(n2 >> 8);
        byArray[n3 + 2] = (byte)(n2 >> 16);
        byArray[n3 + 3] = n2 >> 24;
    }

    public static byte[] int2byteLE(int n2) {
        byte[] byArray = new byte[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            byArray[i2] = (byte)(n2 >>> 4 * (3 - i2));
        }
        return byArray;
    }

    public static byte[] long2byteLE(long l2) {
        byte[] byArray = new byte[8];
        for (int i2 = 0; i2 < 8; ++i2) {
            byArray[i2] = (byte)(l2 >>> 8 * (7 - i2));
        }
        return byArray;
    }

    public static int getWidthByOptLevel(int n2) {
        if (n2 == 0 || n2 > 20) {
            return 0;
        }
        return n2 + 1;
    }

    public static void copy(int[] nArray, int[] nArray2) {
        int n2 = nArray.length;
        int n3 = nArray2.length;
        n3 -= n2;
        for (int i2 = 0; i2 < n3; ++i2) {
            nArray2[i2] = 0;
        }
        System.arraycopy(nArray, 0, nArray2, n3, n2);
    }

    public static long[] copy(long[] lArray) {
        int n2 = lArray.length;
        long[] lArray2 = new long[n2];
        System.arraycopy(lArray, 0, lArray2, 0, n2);
        return lArray2;
    }

    public static int[] copy(int[] nArray) {
        int n2 = nArray.length;
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    public static byte[] copy(byte[] byArray) {
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    public static byte[] justifyArray(byte[] byArray, int n2) {
        int n3;
        for (n3 = 0; n3 < byArray.length && byArray[n3] == 0; ++n3) {
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n3, byArray2, n2 - byArray.length + n3, byArray.length - n3);
        return byArray2;
    }

    public static byte[] toByteArray(int[] nArray, int n2) {
        byte[] byArray = new byte[n2];
        Utils.toByteArray(nArray, byArray);
        return byArray;
    }

    public static void toByteArray(int[] nArray, byte[] byArray) {
        int n2;
        int n3 = byArray.length - 1;
        int n4 = nArray.length - 1;
        while (n4 > 0 && n3 >= 3) {
            n2 = nArray[n4--];
            byArray[n3--] = (byte)n2;
            byArray[n3--] = (byte)(n2 >>> 8);
            byArray[n3--] = (byte)(n2 >>> 16);
            byArray[n3--] = n2 >> 24;
        }
        for (n2 = 0; n3 >= 0 && n2 < 32; n2 += 8) {
            byArray[n3--] = (byte)(nArray[n4] >>> n2);
        }
        while (n3 >= 0) {
            byArray[n3] = 0;
            --n3;
        }
    }

    public static int[] fromByteArray(byte[] byArray, int n2) {
        int n3;
        int n4 = byArray.length;
        for (n3 = 0; n3 < n4 && byArray[n3] == 0; ++n3) {
        }
        int[] nArray = new int[n2 > (n3 = n4 - n3 + 3 >>> 2) ? n2 : n3];
        Utils.fromByteArray(byArray, nArray);
        return nArray;
    }

    public static void fromByteArray(byte[] byArray, int[] nArray) {
        int n2;
        int n3 = nArray.length - 1;
        for (n2 = byArray.length - 1; n2 >= 4 && n3 >= 0; n2 -= 4) {
            nArray[n3--] = byArray[n2] & 0xFF | (byArray[n2 - 1] & 0xFF) << 8 | (byArray[n2 - 2] & 0xFF) << 16 | (byArray[n2 - 3] & 0xFF) << 24;
        }
        if (n3 >= 0) {
            int n4;
            for (n4 = 0; n4 <= n3; ++n4) {
                nArray[n4] = 0;
            }
            n4 = 0;
            while (n2 >= 0) {
                int n5 = n3;
                nArray[n5] = nArray[n5] | (byArray[n2] & 0xFF) << n4;
                --n2;
                n4 += 8;
            }
        }
    }

    public static int wordLength(int[] nArray) {
        int n2;
        int n3 = nArray.length - 1;
        for (n2 = 0; n2 < n3 && nArray[n2] == 0; ++n2) {
        }
        return n3 + 1 - n2;
    }

    public static int byteLength(byte[] byArray) {
        int n2;
        int n3 = byArray.length - 1;
        for (n2 = 0; n2 < n3 && byArray[n2] == 0; ++n2) {
        }
        return n3 + 1 - n2;
    }

    public static void clean(long[] lArray) {
        if (lArray != null) {
            for (int i2 = lArray.length - 1; i2 >= 0; --i2) {
                lArray[i2] = 0L;
            }
        }
    }

    public static void clean(int[] nArray) {
        if (nArray != null) {
            for (int i2 = nArray.length - 1; i2 >= 0; --i2) {
                nArray[i2] = 0;
            }
        }
    }

    public static void clean(byte[] byArray) {
        if (byArray != null) {
            for (int i2 = byArray.length - 1; i2 >= 0; --i2) {
                byArray[i2] = 0;
            }
        }
    }

    public static int getBit(byte[] byArray, int n2) {
        return byArray[n2 >> 3] >> (n2 & 7) & 1;
    }

    public static void setBit(byte[] byArray, int n2, int n3) {
        int n4 = n2 >> 3;
        byArray[n4] = (byte)(byArray[n4] & ~(1 << (n2 & 7)));
        int n5 = n2 >> 3;
        byArray[n5] = (byte)(byArray[n5] | n3 << (n2 & 7));
    }

    public static void addInt(int[] nArray, int[] nArray2, int n2, int[] nArray3) {
        long l2 = 0L;
        --n2;
        while (n2 >= 0) {
            l2 = (l2 >>> 32) + ((long)nArray[n2] & 0xFFFFFFFFL) + ((long)nArray2[n2] & 0xFFFFFFFFL);
            nArray3[n2] = (int)l2;
            --n2;
        }
    }

    public static void addInt(int[] nArray, int n2, int[] nArray2, int n3, int n4, int[] nArray3, int n5) {
        long l2 = 0L;
        --n4;
        while (n4 >= 0) {
            l2 = (l2 >>> 32) + ((long)nArray[n4 + n2] & 0xFFFFFFFFL) + ((long)nArray2[n4 + n3] & 0xFFFFFFFFL);
            nArray3[n4 + n5] = (int)l2;
            --n4;
        }
    }

    public static void intToBigEndian(int n2, byte[] byArray, int n3) {
        for (int i2 = 0; i2 < 4; ++i2) {
            byArray[n3 + i2] = (byte)(n2 >>> 24 - (i2 << 3));
        }
    }

    public static void longToBigEndian(long l2, byte[] byArray, int n2) {
        Utils.intToBigEndian((int)(l2 >>> 32), byArray, n2);
        Utils.intToBigEndian((int)l2, byArray, n2 + 4);
    }

    public static int bigEndianToInt(byte[] byArray, int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            n3 |= (byArray[n2 + i2] & 0xFF) << 24 - (i2 << 3);
        }
        return n3;
    }

    public static long bigEndianToLong(byte[] byArray, int n2) {
        return ((long)Utils.bigEndianToInt(byArray, n2) & 0xFFFFFFFFL) << 32 | (long)Utils.bigEndianToInt(byArray, n2 + 4) & 0xFFFFFFFFL;
    }

    public static byte[] swap(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray2[byArray2.length - i2 - 1] = byArray[i2];
        }
        return byArray2;
    }
}

