/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.core;

import com.bifit.security.core.DSTU4145ECParams;
import com.bifit.security.core.DSTU4145ECPrivateKey;
import com.bifit.security.core.DSTU4145ECPublicKey;
import com.bifit.security.core.GOST28147CipherParams;
import com.bifit.security.core.GOST28147SecretKey;
import com.bifit.security.core.GOST3411Digest;
import com.bifit.security.core.LongIntUtils;
import com.bifit.security.core.Utils;
import com.bifit.security.core.n;
import com.bifit.security.core.p;

public final class ISO15946 {
    private int[] a;
    private DSTU4145ECPrivateKey b;
    private DSTU4145ECParams c;
    private byte[] d = null;
    private byte[] e = null;
    private static GOST3411Digest f;
    private GOST28147CipherParams g = GOST28147CipherParams.DEFAULT_8;
    private static final byte[] h;

    public final void init(DSTU4145ECPrivateKey dSTU4145ECPrivateKey, GOST28147CipherParams gOST28147CipherParams) {
        this.c = dSTU4145ECPrivateKey.getParams();
        this.a = this.c.getCofactor();
        this.b = dSTU4145ECPrivateKey;
        if (gOST28147CipherParams != null) {
            this.g = gOST28147CipherParams;
            return;
        }
        this.g = GOST28147CipherParams.DEFAULT_8;
    }

    private void a(DSTU4145ECPublicKey object, boolean bl) {
        if (this.c == null) {
            throw new IllegalStateException("instance was not initialized");
        }
        if (!this.c.equals(((DSTU4145ECPublicKey)object).getParams())) {
            throw new IllegalArgumentException("different cryptographic parameters used for local private key and remote public key");
        }
        this.d = null;
        this.e = null;
        p p2 = new p(this.c);
        object = ((DSTU4145ECPublicKey)object).a();
        n n2 = new n(p2.a().getZero(), p2.a().getZero());
        p2.a((n)object, this.a, n2);
        if (n2.equals(p2.c())) {
            throw new IllegalArgumentException("invalid remote public key specified");
        }
        if (bl) {
            p2.a(n2, this.b.a(), n2);
        } else {
            p2.a((n)object, this.b.a(), n2);
        }
        int n3 = this.c.a()[0] + 7 >>> 3;
        if (this.c.isONB()) {
            long[] lArray = new long[p2.b()];
            long[] lArray2 = new long[p2.b()];
            LongIntUtils.copy(n2.a(), lArray);
            LongIntUtils.copy(n2.b(), lArray2);
            this.c.b(p2.a(), lArray);
            this.c.b(p2.a(), lArray2);
            this.d = LongIntUtils.toByteArray(lArray, n3);
            this.e = LongIntUtils.toByteArray(lArray2, n3);
            Utils.clean(n2.a());
            Utils.clean(n2.b());
            Utils.clean(lArray);
            Utils.clean(lArray2);
            return;
        }
        this.d = LongIntUtils.toByteArray(n2.a(), n3);
        this.e = LongIntUtils.toByteArray(n2.b(), n3);
        Utils.clean(n2.a());
        Utils.clean(n2.b());
    }

    public final void generateSharedSecret(DSTU4145ECPublicKey dSTU4145ECPublicKey) {
        this.a(dSTU4145ECPublicKey, false);
    }

    public final void generateSharedSecretWithCofactor(DSTU4145ECPublicKey dSTU4145ECPublicKey) {
        this.a(dSTU4145ECPublicKey, true);
    }

    public final byte[] getZZx() {
        if (this.d != null) {
            byte[] byArray = new byte[this.d.length];
            System.arraycopy(this.d, 0, byArray, 0, this.d.length);
            return byArray;
        }
        throw new RuntimeException("The shared secret was not generated!");
    }

    public final byte[] getZZy() {
        if (this.e != null) {
            byte[] byArray = new byte[this.e.length];
            System.arraycopy(this.e, 0, byArray, 0, this.e.length);
            return byArray;
        }
        throw new RuntimeException("The shared secret was not generated!");
    }

    public static GOST28147SecretKey generateANSI963Key(GOST28147CipherParams gOST28147CipherParams, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4;
        int n2 = 2 + byArray3.length + 2;
        int n3 = n2 + 2 + 8;
        if (byArray2 != null) {
            byte[] byArray5 = new byte[n3 += 68];
            byArray4 = byArray5;
            byArray5[n2 + 2] = -96;
            byArray4[n2 + 2 + 1] = 66;
            byArray4[n2 + 2 + 2] = 4;
            byArray4[n2 + 2 + 3] = 64;
            System.arraycopy(byArray2, 0, byArray4, n2 + 6, 64);
        } else {
            byArray4 = new byte[n3];
        }
        byArray4[0] = 48;
        byArray4[1] = (byte)(n3 - 2);
        byArray4[2] = 48;
        byArray4[3] = (byte)(n2 - 2);
        System.arraycopy(byArray3, 0, byArray4, 4, byArray3.length);
        byArray4[n2] = 5;
        byArray4[n2 + 1] = 0;
        byArray4[n3 - 8] = -94;
        byArray4[n3 - 8 + 1] = 6;
        byArray4[n3 - 8 + 2] = 4;
        byArray4[n3 - 8 + 3] = 4;
        Utils.intToBigEndian(256, byArray4, n3 - 8 + 4);
        byArray2 = byArray4;
        f = new GOST3411Digest(gOST28147CipherParams);
        f.init(new byte[32]);
        f.update(byArray, 0, byArray.length);
        f.update(h, 0, h.length);
        f.update(byArray2, 0, byArray2.length);
        return new GOST28147SecretKey(Utils.swap(f.doFinal()));
    }

    public final GOST28147SecretKey generateANSI963Key(byte[] byArray, byte[] byArray2) {
        if (this.d != null) {
            return ISO15946.generateANSI963Key(this.g, this.d, byArray, byArray2);
        }
        throw new RuntimeException("The shared secret was not generated!");
    }

    public static GOST28147SecretKey generateANSI942Key(GOST28147CipherParams gOST28147CipherParams, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[]{4, 4, 0, 0, 0, 1};
        byte[] byArray5 = new byte[]{-94, 6, 4, 4, 0, 0, 1, 0};
        int n2 = byArray5.length;
        int n3 = byArray3.length + byArray4.length;
        byte[] byArray6 = new byte[n3 + 2];
        byte[] byArray7 = byArray6;
        byArray6[0] = 48;
        byArray7[1] = (byte)n3;
        System.arraycopy(byArray3, 0, byArray7, 2, byArray3.length);
        System.arraycopy(byArray4, 0, byArray7, byArray3.length + 2, byArray4.length);
        n2 += byArray7.length;
        int n4 = byArray7.length + 2;
        if (byArray2 != null) {
            byArray4 = new byte[byArray2.length + 4];
            n2 += byArray4.length;
            byArray4[0] = -96;
            byArray4[1] = (byte)(byArray2.length + 2);
            byArray4[2] = 4;
            byArray4[3] = (byte)byArray2.length;
            System.arraycopy(byArray2, 0, byArray4, 4, byArray2.length);
            byArray2 = new byte[n2 + 2];
            System.arraycopy(byArray4, 0, byArray2, n4, byArray4.length);
            n4 += byArray4.length;
        } else {
            byArray2 = new byte[n2 + 2];
        }
        byArray2[0] = 48;
        byArray2[1] = (byte)n2;
        System.arraycopy(byArray7, 0, byArray2, 2, byArray7.length);
        System.arraycopy(byArray5, 0, byArray2, n4, byArray5.length);
        f = new GOST3411Digest(gOST28147CipherParams);
        f.init(new byte[32]);
        f.update(byArray, 0, byArray.length);
        f.update(byArray2, 0, byArray2.length);
        return new GOST28147SecretKey(Utils.swap(f.doFinal()));
    }

    public final GOST28147SecretKey generateANSI942Key(byte[] byArray, byte[] byArray2) {
        if (this.d != null) {
            return ISO15946.generateANSI942Key(GOST28147CipherParams.DEFAULT_8, this.d, byArray, byArray2);
        }
        throw new RuntimeException("The shared secret was not generated!");
    }

    public final void free() {
        Utils.clean(this.d);
        Utils.clean(this.e);
        this.d = null;
        this.e = null;
    }

    static {
        h = new byte[]{0, 0, 0, 1};
    }
}

