/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.core;

import com.bifit.security.core.BigInt;
import com.bifit.security.core.GFp;
import com.bifit.security.core.GOST3410Params;
import com.bifit.security.core.Utils;

public final class GOST3410PublicKey {
    private final GOST3410Params a;
    private final int[] b;
    private int[][] c;

    public GOST3410PublicKey(GOST3410Params gOST3410Params, byte[] byArray) {
        int[] nArray = gOST3410Params.a();
        int[] nArray2 = Utils.fromByteArray(byArray, nArray.length);
        if (BigInt.bitLength(nArray2) <= 1 || Utils.byteLength(byArray) > 4 * Utils.wordLength(nArray) || BigInt.compare(nArray2, nArray) >= 0) {
            throw new IllegalArgumentException("condition 1 < y < p is not met");
        }
        this.a = gOST3410Params;
        this.b = nArray2;
    }

    GOST3410PublicKey(GOST3410Params gOST3410Params, int[] nArray) {
        this.a = gOST3410Params;
        this.b = nArray;
    }

    public final boolean validate() {
        GFp gFp = new GFp(this.a.a());
        int[] nArray = new int[32];
        gFp.modPow(this.b, this.a.b(), nArray);
        return BigInt.bitLength(nArray) == 1;
    }

    public final byte[] getY() {
        return Utils.toByteArray(this.b, 4 * Utils.wordLength(this.a.a()));
    }

    public final GOST3410Params getParams() {
        return this.a;
    }

    public final synchronized void setOptLevel(int n2) {
        if ((n2 = Utils.getWidthByOptLevel(n2)) != 0) {
            GFp gFp = new GFp(this.a.a(), 2);
            int[] nArray = new int[32];
            gFp.toInternalDomain(this.b, nArray);
            this.c = gFp.getCombPrecomp(nArray, n2);
            return;
        }
        this.c = null;
    }

    public final synchronized void setOptData(byte[] byArray) {
        if (byArray != null) {
            GFp gFp = new GFp(this.a.a(), 2);
            this.c = gFp.importPrecomp(byArray);
            return;
        }
        this.c = null;
    }

    public final synchronized byte[] getOptData() {
        if (this.c != null) {
            return GFp.exportPrecomp(this.a.a(), this.c);
        }
        return null;
    }

    final int[] a() {
        return this.b;
    }

    final synchronized int[][] b() {
        return this.c;
    }
}

