/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.core;

import com.bifit.security.core.BigInt;
import com.bifit.security.core.GOST3410Params;
import com.bifit.security.core.Utils;

public final class GOST3410PrivateKey {
    private int[] a;
    private final GOST3410Params b;

    public GOST3410PrivateKey(GOST3410Params gOST3410Params, byte[] byArray) {
        int[] nArray = gOST3410Params.b();
        int n2 = nArray.length;
        int[] nArray2 = Utils.fromByteArray(byArray, n2);
        if (BigInt.bitLength(nArray2) == 0 || Utils.byteLength(byArray) > 4 * Utils.wordLength(nArray) || BigInt.compare(nArray2, nArray) >= 0) {
            Utils.clean(nArray2);
            throw new IllegalArgumentException("condition 0 < x < q is not met");
        }
        this.b = gOST3410Params;
        this.a = nArray2;
    }

    GOST3410PrivateKey(GOST3410Params gOST3410Params, int[] nArray) {
        this.b = gOST3410Params;
        this.a = nArray;
    }

    public final byte[] getX() {
        if (this.a == null) {
            throw new IllegalStateException("key was deallocated");
        }
        return Utils.toByteArray(this.a, 32);
    }

    public final void free() {
        Utils.clean(this.a);
        this.a = null;
    }

    public final GOST3410Params getParams() {
        return this.b;
    }

    final int[] a() {
        if (this.a == null) {
            throw new IllegalStateException("key was deallocated");
        }
        return this.a;
    }
}

