/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.core;

import com.bifit.security.core.BigInt;
import com.bifit.security.core.ECDSAParams;
import com.bifit.security.core.ECDSAPrivateKey;
import com.bifit.security.core.ECDSAPublicKey;
import com.bifit.security.core.m;
import com.bifit.security.core.o;
import java.security.SecureRandom;
import java.util.Random;

public class ECDSAKeyPairGenerator {
    private final SecureRandom a;
    private ECDSAPublicKey b = null;
    private ECDSAPrivateKey c = null;
    private ECDSAParams d = null;

    public ECDSAKeyPairGenerator(int n2, SecureRandom secureRandom) {
        if (n2 != 192 && n2 != 224 && n2 != 256 && n2 != 384 && n2 != 521) {
            throw new IllegalArgumentException("size must be from 192, 224, 256, 384, 521");
        }
        this.a = secureRandom;
        this.d = ECDSAParams.getParams(n2);
    }

    public ECDSAKeyPairGenerator(ECDSAParams eCDSAParams, SecureRandom secureRandom) {
        this.a = secureRandom;
        this.d = eCDSAParams;
    }

    public void generate() {
        int n2 = this.d.f();
        int[] nArray = this.d.e();
        int[] nArray2 = new int[n2];
        BigInt bigInt = new BigInt(n2);
        do {
            bigInt.getRandomNumber((Random)this.a, nArray, nArray2);
        } while (BigInt.equals(nArray2, bigInt.getZero()) || BigInt.compare(nArray2, nArray) >= 0);
        this.c = new ECDSAPrivateKey(this.d, nArray2);
        this.b = ECDSAKeyPairGenerator.getPublicByPrivate(this.c);
    }

    public ECDSAPublicKey getPublic() {
        if (this.b == null) {
            throw new IllegalStateException("key pair were not generated");
        }
        return this.b;
    }

    public ECDSAPrivateKey getPrivate() {
        if (this.b == null) {
            throw new IllegalStateException("key pair were not generated");
        }
        return this.c;
    }

    public static ECDSAPublicKey getPublicByPrivate(ECDSAPrivateKey eCDSAPrivateKey) {
        ECDSAParams eCDSAParams = eCDSAPrivateKey.getParams();
        o o2 = new o(eCDSAParams);
        m m2 = eCDSAParams.a();
        m m3 = new m(o2.b().getZero(), o2.b().getZero());
        o2.a(m2, eCDSAPrivateKey.a(), m3);
        return new ECDSAPublicKey(eCDSAParams, m3);
    }
}

