/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.core;

import com.bifit.security.core.BigInt;
import com.bifit.security.core.DSTU4145ECParams;
import com.bifit.security.core.DSTU4145ECPrivateKey;
import com.bifit.security.core.DSTU4145ECPublicKey;
import com.bifit.security.core.GF2m;
import com.bifit.security.core.LongIntUtils;
import com.bifit.security.core.SecurePRNG;
import com.bifit.security.core.Utils;
import com.bifit.security.core.n;
import com.bifit.security.core.p;

public final class DSTU4145ECSign {
    private SecurePRNG a;
    private DSTU4145ECPrivateKey b = null;
    private n c = null;
    private DSTU4145ECParams d = null;
    private p e;
    private byte[] f;
    private byte[] g;
    private long[] h = null;
    private long[] i;
    private int[] j;
    private int[] k;
    private int[] l;
    private long[] m;
    private n n;
    private int[] o;

    private void a() {
        this.e = new p(this.d);
        int n2 = this.d.getSignatureLength() / 2;
        this.f = new byte[n2];
        this.g = new byte[n2];
        n2 = this.e.b();
        if (this.h == null || this.h.length != n2) {
            this.h = new long[n2];
            this.i = new long[n2];
            this.m = new long[n2];
            this.j = new int[2 * n2];
            this.k = new int[2 * n2];
            this.l = new int[2 * n2];
            this.o = new int[4 * n2];
            this.n = new n(new long[n2], new long[n2]);
        }
    }

    public final void initSign(DSTU4145ECPrivateKey dSTU4145ECPrivateKey, SecurePRNG securePRNG) {
        if (!dSTU4145ECPrivateKey.getParams().equals(this.d)) {
            this.d = dSTU4145ECPrivateKey.getParams();
            this.a();
        }
        this.a = securePRNG;
        this.b = dSTU4145ECPrivateKey;
        this.c = null;
    }

    public final byte[] sign(byte[] byArray) {
        if (this.b == null) {
            if (this.c == null) {
                throw new IllegalStateException("instance was not initialized");
            }
            throw new IllegalStateException("instance is initialized for verification of digital signature");
        }
        if (byArray.length != 32) {
            throw new IllegalArgumentException("wrong hash length");
        }
        Object object = this.d.d();
        int[] nArray = this.d.c();
        GF2m gF2m = this.e.a();
        BigInt bigInt = gF2m.getBigInt();
        LongIntUtils.fromByteArray(byArray, this.h);
        LongIntUtils.truncate(this.h, gF2m.getF()[0]);
        if (this.d.isONB()) {
            this.d.a(gF2m, this.h);
        }
        if (LongIntUtils.equals(this.h, gF2m.getZero())) {
            LongIntUtils.copy(gF2m.getOne(), this.h);
        }
        while (true) {
            this.a.a(this.l);
            BigInt.truncate(this.l, BigInt.bitLength(nArray) - 1);
            this.e.a((n)object, this.l, this.n);
            gF2m.multiply(this.n.a(), this.h, this.i);
            if (this.d.isONB()) {
                this.d.b(gF2m, this.i);
            }
            GF2m.toInteger(this.i, nArray);
            if (LongIntUtils.equals(this.i, gF2m.getZero())) continue;
            LongIntUtils.toIntArray(this.i, this.j);
            bigInt.multiply(this.b.a(), this.j, this.o);
            bigInt.divide(this.o, nArray, null, this.k);
            if (bigInt.add(this.l, this.k, this.k) > 0 || BigInt.compare(this.k, nArray) >= 0) {
                bigInt.subtract(this.k, nArray, this.k);
            }
            Utils.clean(this.o);
            Utils.clean(this.l);
            if (!BigInt.equals(this.k, bigInt.getZero())) break;
        }
        int n2 = this.d.getSignatureLength();
        object = new byte[n2];
        LongIntUtils.toByteArray(this.i, this.f);
        Utils.toByteArray(this.k, this.g);
        System.arraycopy(this.g, 0, object, 0, n2 >>>= 1);
        System.arraycopy(this.f, 0, object, n2, n2);
        return object;
    }

    public final void initVerify(DSTU4145ECPublicKey dSTU4145ECPublicKey) {
        if (!dSTU4145ECPublicKey.getParams().equals(this.d)) {
            this.d = dSTU4145ECPublicKey.getParams();
            this.a();
        }
        this.c = dSTU4145ECPublicKey.a();
        this.b = null;
    }

    public final boolean verify(byte[] byArray, byte[] byArray2) {
        int n2;
        if (this.c == null) {
            if (this.b == null) {
                throw new IllegalStateException("instance was not initialized");
            }
            throw new IllegalStateException("instance is initialized for generation of digital signature");
        }
        if (byArray.length != 32) {
            throw new IllegalArgumentException("wrong hash length");
        }
        n n3 = this.d.d();
        int[] nArray = this.d.c();
        GF2m gF2m = this.e.a();
        BigInt bigInt = gF2m.getBigInt();
        int n4 = byArray2.length;
        int n5 = this.d.getSignatureLength();
        if ((n4 & 1) == 1 || n4 < n5) {
            return false;
        }
        n4 >>>= 1;
        n5 >>>= 1;
        for (n2 = 0; n2 < n4 - n5; ++n2) {
            if (byArray2[n2] == 0) continue;
            return false;
        }
        for (n2 = n4; n2 < 2 * n4 - n5; ++n2) {
            if (byArray2[n2] == 0) continue;
            return false;
        }
        System.arraycopy(byArray2, n4 - n5, this.g, 0, n5);
        System.arraycopy(byArray2, 2 * n4 - n5, this.f, 0, n5);
        Utils.fromByteArray(this.g, this.k);
        Utils.fromByteArray(this.f, this.j);
        if (BigInt.compare(this.j, nArray) >= 0 || BigInt.compare(this.k, nArray) >= 0 || BigInt.equals(this.j, bigInt.getZero()) || BigInt.equals(this.k, bigInt.getZero())) {
            return false;
        }
        LongIntUtils.fromByteArray(byArray, this.h);
        LongIntUtils.truncate(this.h, gF2m.getF()[0]);
        if (this.d.isONB()) {
            this.d.a(gF2m, this.h);
        }
        if (LongIntUtils.equals(this.h, gF2m.getZero())) {
            LongIntUtils.copy(gF2m.getOne(), this.h);
        }
        this.e.a(n3, this.k, this.c, this.j, this.n);
        gF2m.multiply(this.n.a(), this.h, this.m);
        if (this.d.isONB()) {
            this.d.b(gF2m, this.m);
        }
        GF2m.toInteger(this.m, nArray);
        LongIntUtils.fromIntArray(this.j, this.i);
        return LongIntUtils.equals(this.m, this.i);
    }
}

