/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.core;

import com.bifit.security.core.BigInt;
import com.bifit.security.core.GFp;
import com.bifit.security.core.Utils;

public class DSAParams {
    private int[][] a = null;
    private final int b;
    private final int[] c;
    private final int[] d;
    private final int[] e;

    DSAParams(int[] nArray, int[] nArray2, int[] nArray3) {
        this.c = Utils.copy(nArray3);
        this.e = Utils.copy(nArray);
        this.d = Utils.copy(nArray2);
        this.b = nArray.length;
    }

    public DSAParams(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.b = byArray.length / 4;
        this.c = Utils.fromByteArray(byArray3, this.b);
        this.e = Utils.fromByteArray(byArray, this.b);
        this.d = Utils.fromByteArray(byArray2, this.b);
    }

    public byte[] getP() {
        return Utils.toByteArray(this.e, 4 * Utils.wordLength(this.e));
    }

    public byte[] getQ() {
        return Utils.toByteArray(this.d, 4 * Utils.wordLength(this.d));
    }

    public byte[] getG() {
        return Utils.toByteArray(this.c, 4 * Utils.wordLength(this.c));
    }

    public int getSignatureLength() {
        return BigInt.bitLength(this.d) + 7 >>> 3 << 1;
    }

    final int[] a() {
        return this.e;
    }

    final int[] b() {
        return this.d;
    }

    final int[] c() {
        return this.c;
    }

    final int d() {
        return this.b;
    }

    final synchronized int[][] e() {
        return this.a;
    }

    public synchronized void setOptLevel(int n2) {
        if ((n2 = Utils.getWidthByOptLevel(n2)) != 0) {
            GFp gFp = new GFp(this.e, 2);
            int[] nArray = new int[this.b];
            gFp.toInternalDomain(this.c, nArray);
            this.a = gFp.getCombPrecomp(nArray, n2);
            return;
        }
        this.a = null;
    }

    public synchronized void setOptData(byte[] object) {
        if (object != null) {
            GFp gFp = new GFp(this.e, 2);
            int[] nArray = new int[this.b];
            object = gFp.importPrecomp((byte[])object);
            gFp.toInternalDomain(this.c, nArray);
            if (!BigInt.equals(nArray, (int[])object[1])) {
                throw new IllegalArgumentException("precomputations are not for current GF(p) element a");
            }
            this.a = (int[][])object;
            return;
        }
        this.a = null;
    }

    public synchronized byte[] getOptData() {
        if (this.a != null) {
            return GFp.exportPrecomp(this.e, this.a);
        }
        return null;
    }
}

