/*
 * Decompiled with CFR 0.152.
 */
package ua.com.dbosoft.autoclient.app.ua_payment;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import ua.com.dbosoft.autoclient.app.account.Iban;
import ua.com.dbosoft.autoclient.app.client.OrgCodeKeying;
import ua.com.dbosoft.autoclient.app.j;
import ua.com.dbosoft.autoclient.app.ua_payment.BPTemplateTypeSerializer;
import ua.com.dbosoft.autoclient.app.ua_payment.BpSingleAccountRow;
import ua.com.dbosoft.autoclient.app.ua_payment.b;
import ua.com.dbosoft.autoclient.format.ibank2.c;
import ua.com.dbosoft.autoclient.format.json.BigDecimalSerializer;
import ua.com.dbosoft.autoclient.format.json.LocalDateSerializer;

public class UaPayment
implements j {
    private static final ua.com.dbosoft.autoclient.format.ibank2.b<UaPayment> UA_PAYMENT_WRITER = new ua.com.dbosoft.autoclient.format.ibank2.b<UaPayment>(UaPayment.class);
    private long id;
    private Integer statusCode;
    @JsonProperty(value="DATE_DOC")
    @JsonSerialize(using=LocalDateSerializer.class)
    private LocalDate date;
    @JsonProperty(value="NUM_DOC")
    private String number;
    @JsonProperty(value="AMOUNT")
    @JsonSerialize(using=BigDecimalSerializer.class)
    private BigDecimal amount;
    @JsonProperty(value="CLN_NAME")
    private String clientName;
    @JsonProperty(value="CLN_OKPO")
    private String clientCode;
    @JsonProperty(value="CLN_ACCOUNT")
    private String clientAccount;
    @JsonProperty(value="CLN_BANK_NAME")
    private String clientBankName;
    @JsonProperty(value="CLN_BANK_MFO")
    private String clientBankCode;
    @JsonProperty(value="RCPT_NAME")
    private String recipientName;
    @JsonProperty(value="RCPT_OKPO")
    private String recipientCode;
    @JsonProperty(value="RCPT_ACCOUNT")
    private String recipientAccount;
    @JsonProperty(value="RCPT_BANK_NAME")
    private String recipientBankName;
    @JsonProperty(value="RCPT_BANK_MFO")
    private String recipientBankCode;
    @JsonProperty(value="PAYMENT_DETAILS")
    private String paymentDetails;
    @JsonProperty(value="VALUE_DATE")
    @JsonSerialize(using=LocalDateSerializer.class)
    private LocalDate valueDate;
    @JsonProperty(value="RCPT_COUNTRY_CODE")
    private String recipientCountryCode;
    @JsonProperty(value="CLN_COUNTRY_CODE")
    private String clientCountryCode;
    @JsonProperty(value="EXPENSE_ITEM")
    private String expenseItem;
    @JsonProperty(value="RCPT_PASSP_SER")
    private String recipientPassportSerial;
    @JsonProperty(value="RCPT_PASSP_NUM")
    private String recipientPassportNumber;
    @JsonProperty(value="CLN_PASSP_SER")
    private String clientPassportSerial;
    @JsonProperty(value="CLN_PASSP_NUM")
    private String clientPassportNumber;
    @JsonProperty(value="PRIORITY")
    private String priority;
    @JsonProperty(value="CLN_PASSP_TYPE")
    private Integer clientPassportTypeId;
    @JsonProperty(value="CLN_PASSP_NAME")
    private String clientPassportType;
    @JsonProperty(value="CLN_PROPRIETARY")
    private String clientProprietary;
    @JsonProperty(value="RCPT_PASSP_TYPE")
    private Integer recipientPassportTypeId;
    @JsonProperty(value="RCPT_PASSP_NAME")
    private String recipientPassportType;
    @JsonProperty(value="RCPT_PROPRIETARY")
    private String recipientProprietary;
    @JsonProperty(value="CLN_POSTCODE")
    private String clientPostcode;
    @JsonProperty(value="CLN_REGION")
    private String clientRegion;
    @JsonProperty(value="CLN_DISTRICT")
    private String clientDistrict;
    @JsonProperty(value="CLN_CITY")
    private String clientCity;
    @JsonProperty(value="CLN_STREET")
    private String clientStreet;
    @JsonProperty(value="CLN_HOUSE_NUMBER")
    private String clientHouseNumber;
    @JsonProperty(value="CLN_OFFICE_NUMBER")
    private String clientOfficeNumber;
    @JsonProperty(value="CLN_COUNTRY_LOCATION")
    private String clientCountryLocation;
    @JsonProperty(value="RCPT_POSTCODE")
    private String recipientPostcode;
    @JsonProperty(value="RCPT_REGION")
    private String recipientRegion;
    @JsonProperty(value="RCPT_DISTRICT")
    private String recipientDistrict;
    @JsonProperty(value="RCPT_CITY")
    private String recipientCity;
    @JsonProperty(value="RCPT_STREET")
    private String recipientStreet;
    @JsonProperty(value="RCPT_HOUSE_NUMBER")
    private String recipientHouseNumber;
    @JsonProperty(value="RCPT_OFFICE_NUMBER")
    private String recipientOfficeNumber;
    @JsonProperty(value="RCPT_COUNTRY_LOCATION")
    private String recipientCountryLocation;
    @JsonProperty(value="UETR")
    private String uniqueTransactionIdentifier;
    @JsonProperty(value="UCLN_NAME")
    private String actualPayerName;
    @JsonProperty(value="UCLN_OKPO")
    private String actualPayerCode;
    @JsonProperty(value="UCLN_PASSP_NUM")
    private String actualPayerPassportNumber;
    @JsonProperty(value="UCLN_PASSP_SER")
    private String actualPayerPassportSerial;
    @JsonProperty(value="UCLN_PASSP_TYPE")
    private Integer actualPayerPassportTypeId;
    @JsonProperty(value="UCLN_PASSP_NAME")
    private String actualPayerPassportType;
    @JsonProperty(value="UCLN_PROPRIETARY")
    private String actualPayerProprietary;
    @JsonProperty(value="UCLN_POSTCODE")
    private String actualPayerPostcode;
    @JsonProperty(value="UCLN_REGION")
    private String actualPayerRegion;
    @JsonProperty(value="UCLN_DISTRICT")
    private String actualPayerDistrict;
    @JsonProperty(value="UCLN_CITY")
    private String actualPayerCity;
    @JsonProperty(value="UCLN_STREET")
    private String actualPayerStreet;
    @JsonProperty(value="UCLN_HOUSE_NUMBER")
    private String actualPayerHouseNumber;
    @JsonProperty(value="UCLN_OFFICE_NUMBER")
    private String actualPayerOfficeNumber;
    @JsonProperty(value="UCLN_COUNTRY_LOCATION")
    private String actualPayerCountryLocation;
    @JsonProperty(value="UCLN_COUNTRY_CODE")
    private String actualPayerCountryCode;
    @JsonProperty(value="URCPT_NAME")
    private String actualRecipientName;
    @JsonProperty(value="URCPT_OKPO")
    private String actualRecipientCode;
    @JsonProperty(value="URCPT_PASSP_NUM")
    private String actualRecipientPassportNumber;
    @JsonProperty(value="URCPT_PASSP_SER")
    private String actualRecipientPassportSerial;
    @JsonProperty(value="URCPT_PASSP_TYPE")
    private Integer actualRecipientPassportTypeId;
    @JsonProperty(value="URCPT_PASSP_NAME")
    private String actualRecipientPassportType;
    @JsonProperty(value="URCPT_PROPRIETARY")
    private String actualRecipientProprietary;
    @JsonProperty(value="URCPT_POSTCODE")
    private String actualRecipientPostcode;
    @JsonProperty(value="URCPT_REGION")
    private String actualRecipientRegion;
    @JsonProperty(value="URCPT_DISTRICT")
    private String actualRecipientDistrict;
    @JsonProperty(value="URCPT_CITY")
    private String actualRecipientCity;
    @JsonProperty(value="URCPT_STREET")
    private String actualRecipientStreet;
    @JsonProperty(value="URCPT_HOUSE_NUMBER")
    private String actualRecipientHouseNumber;
    @JsonProperty(value="URCPT_OFFICE_NUMBER")
    private String actualRecipientOfficeNumber;
    @JsonProperty(value="URCPT_COUNTRY_LOCATION")
    private String actualRecipientCountryLocation;
    @JsonProperty(value="URCPT_COUNTRY_CODE")
    private String actualRecipientCountryCode;
    @JsonProperty(value="RCPT_BANK_TYPE")
    private String recipientBankType;
    @JsonProperty(value="RCPT_BANK_ASP_MFO")
    private String recipientAspBankCode;
    @JsonProperty(value="BP_TEMPLATE_TYPE")
    @JsonSerialize(using=BPTemplateTypeSerializer.class)
    private b budgetPaymentTemplateType;
    @JsonProperty(value="BP_TAXCODE")
    private String budgetPaymentTaxCode;
    @JsonProperty(value="BP_ADD_INFO")
    private String budgetPaymentAdditionalInfo;
    @JsonProperty(value="BP_INCOME_CODE")
    private String budgetPaymentIncomeCode;
    @JsonIgnore
    private String budgetPaymentAccount;
    @JsonIgnore
    private String budgetPaymentTaxMsg;
    @JsonProperty(value="BP_SINGLE_ACC_ROWS")
    private List<BpSingleAccountRow> bpSingleAccountRows;

    @c(a="DATE_DOC", b=0, c=false)
    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate localDate) {
        this.date = localDate;
    }

    @c(a="NUM_DOC", b=1, c=false)
    public String getNumber() {
        return this.number;
    }

    public void setNumber(String string) {
        this.number = string;
    }

    @c(b=2, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.AMOUNT}\" (AMOUNT)")
    @Positive(message="{docAmountMustBePositive} (AMOUNT)")
    public @NotNull(message="{emptyRequiredField} \"{desc.AMOUNT}\" (AMOUNT)") @Positive(message="{docAmountMustBePositive} (AMOUNT)") BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal bigDecimal) {
        this.amount = bigDecimal;
    }

    @c(a="CLN_NAME", b=3, c=false)
    @Pattern(regexp="[^\u0401\u0451\u042b\u044b\u042a\u044a\u042d\u044d]+", message="{field} \"{desc.CLN_NAME}\" {containsRussianSymbols} (CLN_NAME)")
    public @Pattern(regexp="[^\u0401\u0451\u042b\u044b\u042a\u044a\u042d\u044d]+", message="{field} \"{desc.CLN_NAME}\" {containsRussianSymbols} (CLN_NAME)") String getClientName() {
        return this.clientName;
    }

    public void setClientName(String string) {
        this.clientName = string;
    }

    @c(a="CLN_OKPO", b=4, c=false)
    public String getClientCode() {
        return this.clientCode;
    }

    public void setClientCode(String string) {
        this.clientCode = string;
    }

    @c(a="CLN_ACCOUNT", b=5, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.CLN_ACCOUNT}\" (CLN_ACCOUNT)")
    public @NotNull(message="{emptyRequiredField} \"{desc.CLN_ACCOUNT}\" (CLN_ACCOUNT)") String getClientAccount() {
        return this.clientAccount;
    }

    public void setClientAccount(String string) {
        this.clientAccount = string;
    }

    @c(a="CLN_BANK_NAME", b=6, c=false)
    public String getClientBankName() {
        return this.clientBankName;
    }

    public void setClientBankName(String string) {
        this.clientBankName = string;
    }

    @c(a="CLN_BANK_MFO", b=7, c=false)
    public String getClientBankCode() {
        return this.clientBankCode;
    }

    public void setClientBankCode(String string) {
        this.clientBankCode = string;
    }

    @c(a="RCPT_NAME", b=8, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.RCPT_NAME}\" (RCPT_NAME)")
    @Size(min=3, message="{fieldSize} \"{desc.RCPT_NAME}\" {mustBeNotLess} {min} {symbols3} (RCPT_NAME)")
    @Pattern(regexp="[^\u0401\u0451\u042b\u044b\u042a\u044a\u042d\u044d]+", message="{field} \"{desc.RCPT_NAME}\" {containsRussianSymbols} (RCPT_NAME)")
    public @NotNull(message="{emptyRequiredField} \"{desc.RCPT_NAME}\" (RCPT_NAME)") @Size(min=3, message="{fieldSize} \"{desc.RCPT_NAME}\" {mustBeNotLess} {min} {symbols3} (RCPT_NAME)") @Pattern(regexp="[^\u0401\u0451\u042b\u044b\u042a\u044a\u042d\u044d]+", message="{field} \"{desc.RCPT_NAME}\" {containsRussianSymbols} (RCPT_NAME)") String getRecipientName() {
        return this.recipientName;
    }

    public void setRecipientName(String string) {
        this.recipientName = string;
    }

    @c(a="RCPT_OKPO", b=9, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.RCPT_OKPO}\" (RCPT_OKPO)")
    @Pattern(regexp="\\d+", message="{field} \"{desc.RCPT_OKPO}\" {mustContainsOnlyDigits} (RCPT_OKPO)")
    @OrgCodeKeying(fieldName="RCPT_OKPO", groups={j.class}, message="{orgCodeKeyingError} {desc.RCPT_OKPO} ${validatedValue} (RCPT_OKPO)")
    public @NotNull(message="{emptyRequiredField} \"{desc.RCPT_OKPO}\" (RCPT_OKPO)") @Pattern(regexp="\\d+", message="{field} \"{desc.RCPT_OKPO}\" {mustContainsOnlyDigits} (RCPT_OKPO)") String getRecipientCode() {
        return this.recipientCode;
    }

    public void setRecipientCode(String string) {
        this.recipientCode = string;
    }

    @c(a="RCPT_ACCOUNT", b=10, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.RCPT_ACCOUNT}\" (RCPT_ACCOUNT)")
    @Iban(fieldName="RCPT_ACCOUNT")
    public @NotNull(message="{emptyRequiredField} \"{desc.RCPT_ACCOUNT}\" (RCPT_ACCOUNT)") String getRecipientAccount() {
        return this.recipientAccount;
    }

    public void setRecipientAccount(String string) {
        this.recipientAccount = string;
    }

    @c(a="RCPT_BANK_NAME", b=11, c=false)
    public String getRecipientBankName() {
        return this.recipientBankName;
    }

    public void setRecipientBankName(String string) {
        this.recipientBankName = string;
    }

    @c(a="RCPT_BANK_MFO", b=12, c=false)
    public String getRecipientBankCode() {
        return this.recipientBankCode;
    }

    public void setRecipientBankCode(String string) {
        this.recipientBankCode = string;
    }

    @c(b=13, c=false)
    @Size(min=3, max=420, message="{fieldSize} \"{desc.PAYMENT_DETAILS}\" {mustBeNotLess} {min} {andNotGreater} {max} {symbols5} (PAYMENT_DETAILS)")
    @Pattern(regexp="[^\u0401\u0451\u042b\u044b\u042a\u044a\u042d\u044d]+", message="{field} \"{desc.PAYMENT_DETAILS}\" {containsRussianSymbols} (PAYMENT_DETAILS)")
    public @Size(min=3, max=420, message="{fieldSize} \"{desc.PAYMENT_DETAILS}\" {mustBeNotLess} {min} {andNotGreater} {max} {symbols5} (PAYMENT_DETAILS)") @Pattern(regexp="[^\u0401\u0451\u042b\u044b\u042a\u044a\u042d\u044d]+", message="{field} \"{desc.PAYMENT_DETAILS}\" {containsRussianSymbols} (PAYMENT_DETAILS)") String getPaymentDetails() {
        return this.paymentDetails;
    }

    public void setPaymentDetails(String string) {
        this.paymentDetails = string;
    }

    @c(b=14, c=false)
    public LocalDate getValueDate() {
        return this.valueDate;
    }

    public void setValueDate(LocalDate localDate) {
        this.valueDate = localDate;
    }

    @c(a="RCPT_COUNTRY_CODE", b=15, c=false)
    public String getRecipientCountryCode() {
        return this.recipientCountryCode;
    }

    public void setRecipientCountryCode(String string) {
        this.recipientCountryCode = string;
    }

    @c(a="CLN_COUNTRY_CODE", b=16, c=false)
    public String getClientCountryCode() {
        return this.clientCountryCode;
    }

    public void setClientCountryCode(String string) {
        this.clientCountryCode = string;
    }

    @c(b=17)
    public String getExpenseItem() {
        return this.expenseItem;
    }

    public void setExpenseItem(String string) {
        this.expenseItem = string;
    }

    @c(a="RCPT_PASSP_SER", b=18)
    public String getRecipientPassportSerial() {
        return this.recipientPassportSerial;
    }

    public void setRecipientPassportSerial(String string) {
        this.recipientPassportSerial = string;
    }

    @c(a="RCPT_PASSP_NUM", b=19)
    public String getRecipientPassportNumber() {
        return this.recipientPassportNumber;
    }

    public void setRecipientPassportNumber(String string) {
        this.recipientPassportNumber = string;
    }

    @c(a="CLN_PASSP_SER", b=20)
    public String getClientPassportSerial() {
        return this.clientPassportSerial;
    }

    public void setClientPassportSerial(String string) {
        this.clientPassportSerial = string;
    }

    @c(a="CLN_PASSP_NUM", b=21)
    public String getClientPassportNumber() {
        return this.clientPassportNumber;
    }

    public void setClientPassportNumber(String string) {
        this.clientPassportNumber = string;
    }

    @c(b=22)
    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String string) {
        this.priority = string;
    }

    @c(a="CLN_PASSP_TYPE", b=23)
    public Integer getClientPassportTypeId() {
        return this.clientPassportTypeId;
    }

    public void setClientPassportTypeId(Integer n2) {
        this.clientPassportTypeId = n2;
    }

    @c(a="CLN_PASSP_NAME", b=24)
    public String getClientPassportType() {
        return this.clientPassportType;
    }

    public void setClientPassportType(String string) {
        this.clientPassportType = string;
    }

    @c(a="CLN_PROPRIETARY", b=25)
    public String getClientProprietary() {
        return this.clientProprietary;
    }

    public void setClientProprietary(String string) {
        this.clientProprietary = string;
    }

    @c(a="RCPT_PASSP_TYPE", b=26)
    public Integer getRecipientPassportTypeId() {
        return this.recipientPassportTypeId;
    }

    public void setRecipientPassportTypeId(Integer n2) {
        this.recipientPassportTypeId = n2;
    }

    @c(a="RCPT_PASSP_NAME", b=27)
    public String getRecipientPassportType() {
        return this.recipientPassportType;
    }

    public void setRecipientPassportType(String string) {
        this.recipientPassportType = string;
    }

    @c(a="RCPT_PROPRIETARY", b=28)
    public String getRecipientProprietary() {
        return this.recipientProprietary;
    }

    public void setRecipientProprietary(String string) {
        this.recipientProprietary = string;
    }

    @c(a="CLN_POSTCODE", b=29)
    public String getClientPostcode() {
        return this.clientPostcode;
    }

    public void setClientPostcode(String string) {
        this.clientPostcode = string;
    }

    @c(a="CLN_REGION", b=30)
    public String getClientRegion() {
        return this.clientRegion;
    }

    public void setClientRegion(String string) {
        this.clientRegion = string;
    }

    @c(a="CLN_DISTRICT", b=31)
    public String getClientDistrict() {
        return this.clientDistrict;
    }

    public void setClientDistrict(String string) {
        this.clientDistrict = string;
    }

    @c(a="CLN_CITY", b=32)
    public String getClientCity() {
        return this.clientCity;
    }

    public void setClientCity(String string) {
        this.clientCity = string;
    }

    @c(a="CLN_STREET", b=33)
    public String getClientStreet() {
        return this.clientStreet;
    }

    public void setClientStreet(String string) {
        this.clientStreet = string;
    }

    @c(a="CLN_HOUSE_NUMBER", b=34)
    public String getClientHouseNumber() {
        return this.clientHouseNumber;
    }

    public void setClientHouseNumber(String string) {
        this.clientHouseNumber = string;
    }

    @c(a="CLN_OFFICE_NUMBER", b=35)
    public String getClientOfficeNumber() {
        return this.clientOfficeNumber;
    }

    public void setClientOfficeNumber(String string) {
        this.clientOfficeNumber = string;
    }

    @c(a="CLN_COUNTRY_LOCATION", b=36)
    public String getClientCountryLocation() {
        return this.clientCountryLocation;
    }

    public void setClientCountryLocation(String string) {
        this.clientCountryLocation = string;
    }

    @c(a="RCPT_POSTCODE", b=37)
    public String getRecipientPostcode() {
        return this.recipientPostcode;
    }

    public void setRecipientPostcode(String string) {
        this.recipientPostcode = string;
    }

    @c(a="RCPT_REGION", b=38)
    public String getRecipientRegion() {
        return this.recipientRegion;
    }

    public void setRecipientRegion(String string) {
        this.recipientRegion = string;
    }

    @c(a="RCPT_DISTRICT", b=39)
    public String getRecipientDistrict() {
        return this.recipientDistrict;
    }

    public void setRecipientDistrict(String string) {
        this.recipientDistrict = string;
    }

    @c(a="RCPT_CITY", b=40)
    public String getRecipientCity() {
        return this.recipientCity;
    }

    public void setRecipientCity(String string) {
        this.recipientCity = string;
    }

    @c(a="RCPT_STREET", b=41)
    public String getRecipientStreet() {
        return this.recipientStreet;
    }

    public void setRecipientStreet(String string) {
        this.recipientStreet = string;
    }

    @c(a="RCPT_HOUSE_NUMBER", b=42)
    public String getRecipientHouseNumber() {
        return this.recipientHouseNumber;
    }

    public void setRecipientHouseNumber(String string) {
        this.recipientHouseNumber = string;
    }

    @c(a="RCPT_OFFICE_NUMBER", b=43)
    public String getRecipientOfficeNumber() {
        return this.recipientOfficeNumber;
    }

    public void setRecipientOfficeNumber(String string) {
        this.recipientOfficeNumber = string;
    }

    @c(a="RCPT_COUNTRY_LOCATION", b=44)
    public String getRecipientCountryLocation() {
        return this.recipientCountryLocation;
    }

    public void setRecipientCountryLocation(String string) {
        this.recipientCountryLocation = string;
    }

    @c(a="UETR", b=45)
    public String getUniqueTransactionIdentifier() {
        return this.uniqueTransactionIdentifier;
    }

    public void setUniqueTransactionIdentifier(String string) {
        this.uniqueTransactionIdentifier = string;
    }

    @c(a="UCLN_NAME", b=46)
    @Pattern(regexp="[^\u0401\u0451\u042b\u044b\u042a\u044a\u042d\u044d]+", message="{field} \"{desc.UCLN_NAME}\" {containsRussianSymbols} (UCLN_NAME)")
    public @Pattern(regexp="[^\u0401\u0451\u042b\u044b\u042a\u044a\u042d\u044d]+", message="{field} \"{desc.UCLN_NAME}\" {containsRussianSymbols} (UCLN_NAME)") String getActualPayerName() {
        return this.actualPayerName;
    }

    public void setActualPayerName(String string) {
        this.actualPayerName = string;
    }

    @c(a="UCLN_OKPO", b=47)
    @Size(min=8, max=10, message="{fieldSize} \"{desc.UCLN_OKPO}\" {mustBeNotLess} {min} {andNotGreater} {max} (UCLN_OKPO)")
    @Pattern(regexp="\\d+", message="{field} \"{desc.UCLN_OKPO}\" {mustContainsOnlyDigits} (UCLN_OKPO)")
    @OrgCodeKeying(fieldName="UCLN_OKPO", groups={j.class}, message="{orgCodeKeyingError} {desc.UCLN_OKPO} ${validatedValue} (UCLN_OKPO)")
    public @Size(min=8, max=10, message="{fieldSize} \"{desc.UCLN_OKPO}\" {mustBeNotLess} {min} {andNotGreater} {max} (UCLN_OKPO)") @Pattern(regexp="\\d+", message="{field} \"{desc.UCLN_OKPO}\" {mustContainsOnlyDigits} (UCLN_OKPO)") String getActualPayerCode() {
        return this.actualPayerCode;
    }

    public void setActualPayerCode(String string) {
        this.actualPayerCode = string;
    }

    @c(a="UCLN_PASSP_NUM", b=48)
    public String getActualPayerPassportNumber() {
        return this.actualPayerPassportNumber;
    }

    public void setActualPayerPassportNumber(String string) {
        this.actualPayerPassportNumber = string;
    }

    @c(a="UCLN_PASSP_SER", b=49)
    public String getActualPayerPassportSerial() {
        return this.actualPayerPassportSerial;
    }

    public void setActualPayerPassportSerial(String string) {
        this.actualPayerPassportSerial = string;
    }

    @c(a="UCLN_PASSP_TYPE", b=50)
    public Integer getActualPayerPassportTypeId() {
        return this.actualPayerPassportTypeId;
    }

    public void setActualPayerPassportTypeId(Integer n2) {
        this.actualPayerPassportTypeId = n2;
    }

    @c(a="UCLN_PASSP_NAME", b=51)
    public String getActualPayerPassportType() {
        return this.actualPayerPassportType;
    }

    public void setActualPayerPassportType(String string) {
        this.actualPayerPassportType = string;
    }

    @c(a="UCLN_PROPRIETARY", b=52)
    public String getActualPayerProprietary() {
        return this.actualPayerProprietary;
    }

    public void setActualPayerProprietary(String string) {
        this.actualPayerProprietary = string;
    }

    @c(a="UCLN_POSTCODE", b=53)
    public String getActualPayerPostcode() {
        return this.actualPayerPostcode;
    }

    public void setActualPayerPostcode(String string) {
        this.actualPayerPostcode = string;
    }

    @c(a="UCLN_REGION", b=54)
    public String getActualPayerRegion() {
        return this.actualPayerRegion;
    }

    public void setActualPayerRegion(String string) {
        this.actualPayerRegion = string;
    }

    @c(a="UCLN_DISTRICT", b=55)
    public String getActualPayerDistrict() {
        return this.actualPayerDistrict;
    }

    public void setActualPayerDistrict(String string) {
        this.actualPayerDistrict = string;
    }

    @c(a="UCLN_CITY", b=56)
    public String getActualPayerCity() {
        return this.actualPayerCity;
    }

    public void setActualPayerCity(String string) {
        this.actualPayerCity = string;
    }

    @c(a="UCLN_STREET", b=57)
    public String getActualPayerStreet() {
        return this.actualPayerStreet;
    }

    public void setActualPayerStreet(String string) {
        this.actualPayerStreet = string;
    }

    @c(a="UCLN_HOUSE_NUMBER", b=58)
    public String getActualPayerHouseNumber() {
        return this.actualPayerHouseNumber;
    }

    public void setActualPayerHouseNumber(String string) {
        this.actualPayerHouseNumber = string;
    }

    @c(a="UCLN_OFFICE_NUMBER", b=59)
    public String getActualPayerOfficeNumber() {
        return this.actualPayerOfficeNumber;
    }

    public void setActualPayerOfficeNumber(String string) {
        this.actualPayerOfficeNumber = string;
    }

    @c(a="UCLN_COUNTRY_LOCATION", b=60)
    public String getActualPayerCountryLocation() {
        return this.actualPayerCountryLocation;
    }

    public void setActualPayerCountryLocation(String string) {
        this.actualPayerCountryLocation = string;
    }

    @c(a="UCLN_COUNTRY_CODE", b=61)
    public String getActualPayerCountryCode() {
        return this.actualPayerCountryCode;
    }

    public void setActualPayerCountryCode(String string) {
        this.actualPayerCountryCode = string;
    }

    @c(a="URCPT_NAME", b=62)
    @Pattern(regexp="[^\u0401\u0451\u042b\u044b\u042a\u044a\u042d\u044d]+", message="{field} \"{desc.URCPT_NAME}\" {containsRussianSymbols} (URCPT_NAME)")
    public @Pattern(regexp="[^\u0401\u0451\u042b\u044b\u042a\u044a\u042d\u044d]+", message="{field} \"{desc.URCPT_NAME}\" {containsRussianSymbols} (URCPT_NAME)") String getActualRecipientName() {
        return this.actualRecipientName;
    }

    public void setActualRecipientName(String string) {
        this.actualRecipientName = string;
    }

    @c(a="URCPT_OKPO", b=63)
    @Pattern(regexp="\\d+", message="{field} \"{desc.URCPT_OKPO}\" {mustContainsOnlyDigits} (URCPT_OKPO)")
    @OrgCodeKeying(fieldName="URCPT_OKPO", groups={j.class}, message="{orgCodeKeyingError} {desc.URCPT_OKPO} ${validatedValue} (URCPT_OKPO)")
    public @Pattern(regexp="\\d+", message="{field} \"{desc.URCPT_OKPO}\" {mustContainsOnlyDigits} (URCPT_OKPO)") String getActualRecipientCode() {
        return this.actualRecipientCode;
    }

    public void setActualRecipientCode(String string) {
        this.actualRecipientCode = string;
    }

    @c(a="URCPT_PASSP_NUM", b=64)
    public String getActualRecipientPassportNumber() {
        return this.actualRecipientPassportNumber;
    }

    public void setActualRecipientPassportNumber(String string) {
        this.actualRecipientPassportNumber = string;
    }

    @c(a="URCPT_PASSP_SER", b=65)
    public String getActualRecipientPassportSerial() {
        return this.actualRecipientPassportSerial;
    }

    public void setActualRecipientPassportSerial(String string) {
        this.actualRecipientPassportSerial = string;
    }

    @c(a="URCPT_PASSP_TYPE", b=66)
    public Integer getActualRecipientPassportTypeId() {
        return this.actualRecipientPassportTypeId;
    }

    public void setActualRecipientPassportTypeId(Integer n2) {
        this.actualRecipientPassportTypeId = n2;
    }

    @c(a="URCPT_PASSP_NAME", b=67)
    public String getActualRecipientPassportType() {
        return this.actualRecipientPassportType;
    }

    public void setActualRecipientPassportType(String string) {
        this.actualRecipientPassportType = string;
    }

    @c(a="URCPT_PROPRIETARY", b=68)
    public String getActualRecipientProprietary() {
        return this.actualRecipientProprietary;
    }

    public void setActualRecipientProprietary(String string) {
        this.actualRecipientProprietary = string;
    }

    @c(a="URCPT_POSTCODE", b=69)
    public String getActualRecipientPostcode() {
        return this.actualRecipientPostcode;
    }

    public void setActualRecipientPostcode(String string) {
        this.actualRecipientPostcode = string;
    }

    @c(a="URCPT_REGION", b=70)
    public String getActualRecipientRegion() {
        return this.actualRecipientRegion;
    }

    public void setActualRecipientRegion(String string) {
        this.actualRecipientRegion = string;
    }

    @c(a="URCPT_DISTRICT", b=71)
    public String getActualRecipientDistrict() {
        return this.actualRecipientDistrict;
    }

    public void setActualRecipientDistrict(String string) {
        this.actualRecipientDistrict = string;
    }

    @c(a="URCPT_CITY", b=72)
    public String getActualRecipientCity() {
        return this.actualRecipientCity;
    }

    public void setActualRecipientCity(String string) {
        this.actualRecipientCity = string;
    }

    @c(a="URCPT_STREET", b=73)
    public String getActualRecipientStreet() {
        return this.actualRecipientStreet;
    }

    public void setActualRecipientStreet(String string) {
        this.actualRecipientStreet = string;
    }

    @c(a="URCPT_HOUSE_NUMBER", b=74)
    public String getActualRecipientHouseNumber() {
        return this.actualRecipientHouseNumber;
    }

    public void setActualRecipientHouseNumber(String string) {
        this.actualRecipientHouseNumber = string;
    }

    @c(a="URCPT_OFFICE_NUMBER", b=75)
    public String getActualRecipientOfficeNumber() {
        return this.actualRecipientOfficeNumber;
    }

    public void setActualRecipientOfficeNumber(String string) {
        this.actualRecipientOfficeNumber = string;
    }

    @c(a="URCPT_COUNTRY_LOCATION", b=76)
    public String getActualRecipientCountryLocation() {
        return this.actualRecipientCountryLocation;
    }

    public void setActualRecipientCountryLocation(String string) {
        this.actualRecipientCountryLocation = string;
    }

    @c(a="URCPT_COUNTRY_CODE", b=77)
    public String getActualRecipientCountryCode() {
        return this.actualRecipientCountryCode;
    }

    public void setActualRecipientCountryCode(String string) {
        this.actualRecipientCountryCode = string;
    }

    @c(a="RCPT_BANK_TYPE", b=78)
    public String getRecipientBankType() {
        return this.recipientBankType;
    }

    public void setRecipientBankType(String string) {
        this.recipientBankType = string;
    }

    @c(a="RCPT_BANK_ASP_MFO", b=79)
    public String getRecipientAspBankCode() {
        return this.recipientAspBankCode;
    }

    public void setRecipientAspBankCode(String string) {
        this.recipientAspBankCode = string;
    }

    public b getBudgetPaymentTemplateType() {
        return this.budgetPaymentTemplateType;
    }

    public void setBudgetPaymentTemplateType(b b2) {
        this.budgetPaymentTemplateType = b2;
    }

    @c(a="BP_TEMPLATE_TYPE", b=80)
    @JsonIgnore
    public Integer getBudgetPaymentTemplateTypeCode() {
        if (this.budgetPaymentTemplateType == null) {
            return null;
        }
        return this.budgetPaymentTemplateType.a();
    }

    public void setBudgetPaymentTemplateTypeCode(Integer n2) {
    }

    @c(a="BP_TAXCODE", b=81)
    public String getBudgetPaymentTaxCode() {
        return this.budgetPaymentTaxCode;
    }

    public void setBudgetPaymentTaxCode(String string) {
        this.budgetPaymentTaxCode = string;
    }

    @c(a="BP_ADD_INFO", b=82)
    @Size(min=3, max=140, message="{fieldSize} \"{desc.BP_ADD_INFO}\" {mustBeNotLess} {min} {andNotGreater} {max} {symbols5} (BP_ADD_INFO)")
    @Pattern(regexp="[^\u0401\u0451\u042b\u044b\u042a\u044a\u042d\u044d]+", message="{field} \"{desc.BP_ADD_INFO}\" {containsRussianSymbols} (BP_ADD_INFO)")
    public @Size(min=3, max=140, message="{fieldSize} \"{desc.BP_ADD_INFO}\" {mustBeNotLess} {min} {andNotGreater} {max} {symbols5} (BP_ADD_INFO)") @Pattern(regexp="[^\u0401\u0451\u042b\u044b\u042a\u044a\u042d\u044d]+", message="{field} \"{desc.BP_ADD_INFO}\" {containsRussianSymbols} (BP_ADD_INFO)") String getBudgetPaymentAdditionalInfo() {
        return this.budgetPaymentAdditionalInfo;
    }

    public void setBudgetPaymentAdditionalInfo(String string) {
        this.budgetPaymentAdditionalInfo = string;
    }

    @c(a="BP_INCOME_CODE", b=83)
    public String getBudgetPaymentIncomeCode() {
        return this.budgetPaymentIncomeCode;
    }

    public void setBudgetPaymentIncomeCode(String string) {
        this.budgetPaymentIncomeCode = string;
    }

    @c(a="BP_ACCOUNT", b=84)
    @Iban(fieldName="BP_ACCOUNT")
    public String getBudgetPaymentAccount() {
        return this.budgetPaymentAccount;
    }

    public void setBudgetPaymentAccount(String string) {
        this.budgetPaymentAccount = string;
    }

    @c(a="BP_TAXMSG", b=85)
    @Size(min=3, max=140, message="{fieldSize} \"{desc.BP_TAXMSG}\" {mustBeNotLess} {min} {andNotGreater} {max} {symbols5} (BP_TAXMSG)")
    @Pattern(regexp="[^\u0401\u0451\u042b\u044b\u042a\u044a\u042d\u044d]+", message="{field} \"{desc.BP_TAXMSG}\" {containsRussianSymbols} (BP_TAXMSG)")
    public @Size(min=3, max=140, message="{fieldSize} \"{desc.BP_TAXMSG}\" {mustBeNotLess} {min} {andNotGreater} {max} {symbols5} (BP_TAXMSG)") @Pattern(regexp="[^\u0401\u0451\u042b\u044b\u042a\u044a\u042d\u044d]+", message="{field} \"{desc.BP_TAXMSG}\" {containsRussianSymbols} (BP_TAXMSG)") String getBudgetPaymentTaxMsg() {
        return this.budgetPaymentTaxMsg;
    }

    public void setBudgetPaymentTaxMsg(String string) {
        this.budgetPaymentTaxMsg = string;
    }

    public List<BpSingleAccountRow> getBpSingleAccountRows() {
        return this.bpSingleAccountRows;
    }

    public void setBpSingleAccountRows(List<BpSingleAccountRow> list) {
        this.bpSingleAccountRows = list;
    }

    @Override
    @JsonIgnore
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long l2) {
        this.id = l2;
    }

    @Override
    public String toIBank2(boolean bl) {
        return UA_PAYMENT_WRITER.a(this, bl);
    }

    @Override
    @JsonIgnore
    public String getType() {
        return "ua_payment";
    }

    @Override
    @JsonIgnore
    public Integer getStatusCode() {
        return this.statusCode;
    }

    @Override
    public void setStatusCode(Integer n2) {
        this.statusCode = n2;
    }
}

